% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liouville.R
\name{theta.bci}
\alias{theta.bci}
\title{Parametric bootstrap confidence interval for the parameter \code{theta} for Liouville copula}
\usage{
theta.bci(B = 1999, family, alphavec, n, theta.hat, quant = c(0.025, 0.975),
  silent = FALSE)
}
\arguments{
\item{B}{number of bootstrap replicates}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers)}

\item{n}{sample size}

\item{theta.hat}{estimate of theta}

\item{quant}{if the vector of probability is specified, the function will return the corresponding bootstrap quantiles}

\item{silent}{boolean for output progress. Default is \code{FALSE}, which means iterations are printed if \eqn{d>2}.}
}
\value{
a list with a 95% confidence inteval unless selected quantiles \code{quant} are supplied
and the bootstrap values of Kendall's tau in \code{boot_tau} if \eqn{d=2} and the model is either \code{gumbel} or \code{clayton}.
Otherwise, the list contains \code{boot_theta}.
}
\description{
The parametric bootstrap provides confidence intervals by repeatedly sampling datasets from the postulated
Liouvilla copula model. If \eqn{d=2} and the model is either \code{gumbel} or \code{clayton}, the value of
Kendall's \eqn{\tau}{tau} is calculated from the sample, and the confidence interval or the quantiles correspond
to the inverse \eqn{\tau^{-1}(\tau(\theta))}{tau} for the bootstrap quantile values of \eqn{\tau}{tau} (using monotonicity).
}
\details{
Since no closed-form formulas exist for the other models or in higher dimension,
the method is extremely slow since it relies on maximization
of a new sample from the model and look up the corresponding parameters.
}
\examples{
theta.bci(B=99, family="gumbel", alphavec=c(2,3), n=1000, theta.hat=2)
## theta.bci(B=19, family="AMH", alphavec=c(1,2), n=100, theta.hat=0.5, quant=c(0.05,0.95))
## theta.bci(B=19, family="frank", alphavec=c(1,2,3), n=100, theta.hat=0.5, quant=c(0.05,0.95))
}

