% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permut.R
\name{permut}
\alias{permut}
\title{Permutation of the latent classes}
\usage{
permut(m, order, estim = TRUE)
}
\arguments{
\item{m}{an object inheriting from classes \code{hlme}, \code{lcmm}, \code{multlcmm} or \code{Jointlcmm}}

\item{order}{a vector (integer between 1 and ng) containing the new order of the latent classes}

\item{estim}{optional boolean specifying if the model should estimated with the reordered parameters as initial values. By default, the model is estimated. If FALSE, only the coefficients in \code{$best} are modified. All other outputs are not changed.}
}
\value{
An object of the same class as m, with reordered classes, or the initial object with new coefficients if estim is FALSE.
}
\description{
This function allows a re-ordering of the latent classes of an estimated model.
}
\examples{

## Estimation of a hlme model with 2 classes
m2 <- hlme(Y~Time*X1,mixture=~Time,random=~Time,classmb=~X2+X3,subject='ID',
         ng=2,data=data_hlme,B=c(0.11,-0.74,-0.07,20.71,
                                 29.39,-1,0.13,2.45,-0.29,4.5,0.36,0.79,0.97))

## Exchange class 2 and class 1
m2b <- permut(m2,order=c(2,1))

}
\author{
Viviane Philipps and Cecile Proust-Lima
}
