% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\name{loglik}
\alias{loglik}
\alias{loglikhlme}
\alias{logliklcmm}
\alias{loglikmultlcmm}
\alias{loglikJointlcmm}
\alias{loglikmpjlcmm}
\title{Wrapper to the Fortran subroutines computing the log-likelihood}
\usage{
loglikhlme(
  b,
  Y0,
  X0,
  prior0,
  pprior0,
  idprob0,
  idea0,
  idg0,
  idcor0,
  ns0,
  ng0,
  nv0,
  nobs0,
  nea0,
  nmes0,
  idiag0,
  nwg0,
  ncor0,
  npm0,
  fix0,
  nfix0,
  bfix0
)

logliklcmm(
  b,
  Y0,
  X0,
  prior0,
  idprob0,
  idea0,
  idg0,
  idcor0,
  ns0,
  ng0,
  nv0,
  nobs0,
  nea0,
  nmes0,
  idiag0,
  nwg0,
  ncor0,
  npm0,
  epsY0,
  idlink0,
  nbzitr0,
  zitr0,
  minY0,
  maxY0,
  ide0,
  fix0,
  nfix0,
  bfix0
)

loglikmultlcmm(
  b,
  Y0,
  X0,
  prior0,
  idprob0,
  idea0,
  idg0,
  idcor0,
  idcontr0,
  ny0,
  ns0,
  ng0,
  nv0,
  nobs0,
  nea0,
  nmes0,
  idiag0,
  nwg0,
  ncor0,
  nalea0,
  npm0,
  epsY0,
  idlink0,
  nbzitr0,
  zitr0,
  uniqueY0,
  indiceY0,
  nvalSPLORD0,
  fix0,
  nfix0,
  bfix0,
  methInteg0,
  nMC0,
  dimMC0,
  seqMC0,
  chol0
)

loglikJointlcmm(
  b,
  Y0,
  X0,
  prior0,
  tentr0,
  tevt0,
  devt0,
  ind_survint0,
  idprob0,
  idea0,
  idg0,
  idcor0,
  idcom0,
  idspecif0,
  idtdv0,
  idlink0,
  epsY0,
  nbzitr0,
  zitr0,
  uniqueY0,
  nvalSPL0,
  indiceY0,
  typrisq0,
  risqcom0,
  nz0,
  zi0,
  ns0,
  ng0,
  nv0,
  nobs0,
  nmes0,
  nbevt0,
  nea0,
  nwg0,
  ncor0,
  idiag0,
  idtrunc0,
  logspecif0,
  npm0,
  fix0,
  nfix0,
  bfix0
)

loglikmpjlcmm(
  b,
  K0,
  ny0,
  nbevt0,
  ng0,
  ns0,
  Y0,
  nobs0,
  X0,
  nv0,
  Xns0,
  nv20,
  prior0,
  Tentr0,
  Tevt0,
  Devt0,
  ind_survint0,
  idnv0,
  idnv20,
  idspecif0,
  idlink0,
  epsY0,
  nbzitr0,
  zitr0,
  uniqueY0,
  nvalSPL0,
  indiceY0,
  typrisq0,
  risqcom0,
  nz0,
  zi0,
  nmes0,
  nea0,
  nw0,
  ncor0,
  nalea0,
  idiag0,
  idtrunc0,
  logspecif0,
  npm0,
  fix0,
  contrainte0,
  nfix0,
  bfix0
)
}
\arguments{
\item{b}{the vector of estimated parameters (length npm0)}

\item{Y0}{the observed values of the outcome(s) (length nobs0)}

\item{X0}{the observed values of all covariates included in the model (dim nob0 * nv0)}

\item{prior0}{the prior latent class (length ns0)}

\item{pprior0}{the prior probabilty of each latent class (dim ns0 * ng0)}

\item{idprob0}{indicator of presence in the class membership submodel (length nv0)}

\item{idea0}{indicator of presence in the random part of the longitudinal submodel (length nv0)}

\item{idg0}{indicator of presence in the fixed part of the longitudinal submodel (length nv0)}

\item{idcor0}{indicator of presence in the correlation part of the longitudinal submodel (length nv0)}

\item{ns0}{number of subjects}

\item{ng0}{number of latent classes}

\item{nv0}{number of covariates}

\item{nobs0}{number of observations}

\item{nea0}{number of random effects}

\item{nmes0}{number of mesures for each subject (length ns0 or dom ns0*ny0)}

\item{idiag0}{indicator of diagonal variance matrix of the random effects}

\item{nwg0}{number of parameters for proportional random effects over latent classes}

\item{ncor0}{number of parameters for the correlation}

\item{npm0}{total number of parameters}

\item{fix0}{indicator of non estimated parameter (length npm0+nfix0)}

\item{nfix0}{number of non estimated parameters}

\item{bfix0}{vector of non estimated parameters}

\item{epsY0}{epsY values for Beta transformations}

\item{idlink0}{type of transformation}

\item{nbzitr0}{number of nodes for the transformations}

\item{zitr0}{nodes for the transformations}

\item{minY0}{minimum value for the longitudinal outcome}

\item{maxY0}{maximum value for the longitudinal outcome}

\item{ide0}{indicator of observed values for ordinal outcomes}

\item{idcontr0}{indicator of presence as contrast in the fixed part of the longitudinal submodel (length nv0)}

\item{ny0}{number of longitudinal outcomes}

\item{nalea0}{number of parameters f the outcome specific random effect}

\item{uniqueY0}{unique values of the longitudinal outcomes}

\item{indiceY0}{correspondance between Y0 and uniqueY0}

\item{nvalSPLORD0}{number of unique values for outcomes modeled with splines transformations or as ordinal outcome}

\item{methInteg0}{type of integration}

\item{nMC0}{number of nodes for Monte Carlo integration}

\item{dimMC0}{dimension of the integration}

\item{seqMC0}{sequence of integration nodes}

\item{chol0}{indicator of Cholesky parameterization}

\item{tentr0}{entry time for the survival submodel}

\item{tevt0}{event time for the survival submodel}

\item{devt0}{indicator of event for the survival submodel}

\item{ind_survint0}{indicator of risk change}

\item{idcom0}{indicator of presence in the survival submodel with common effect}

\item{idspecif0}{indicator of presence in the survival submodel with cause-specific or class specific effect}

\item{idtdv0}{indicator of 'TimeDepVar' covariate}

\item{nvalSPL0}{number of unique values for outcomes modeled with splines transformations}

\item{typrisq0}{type of baseline risk}

\item{risqcom0}{specification of baseline risk across latent classes}

\item{nz0}{number of nodes for the baseline}

\item{zi0}{nodes for the baseline}

\item{nbevt0}{number of events}

\item{idtrunc0}{indicator of left truncation}

\item{logspecif0}{indicator of logarithm parameterization}

\item{K0}{number of latent processes}

\item{Xns0}{the observed values of the covariates included in the survival submodel (dim ns0*nv20)}

\item{nv20}{number of covariates in Xns0}

\item{Tentr0}{entry time for the survival submodel (length ns0)}

\item{Tevt0}{event time for the survival submodel (length ns0)}

\item{Devt0}{indicator of event for the survival submodel (length ns0)}

\item{idnv0}{indicator of presence in each subpart of the longitudinal models (length 4*sum(nv0))}

\item{idnv20}{indicator of presence in each subpart of the survival models (length 3*nv20)}

\item{nw0}{number of parameters for proportional random effects over latent classes}

\item{contrainte0}{type of identifiability constraints}
}
\value{
the log-likelihood
}
\description{
Log-likelihood of hlme, lcmm, multlcmm, Jointlcmm and mpjlcmm models.
The argument's specification is not straightforward, so these functions are usually not directly used.
}
\author{
Cecile Proust-Lima, Viviane Philipps
}
