% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-checkbox.R
\name{lcarsCheckbox}
\alias{lcarsCheckbox}
\title{LCARS checkbox}
\usage{
lcarsCheckbox(
  inputId,
  label,
  value = FALSE,
  color = "atomic-tangerine",
  background_color = "#000000",
  label_color = "#FFFFFF",
  label_right = FALSE,
  width = NULL
)
}
\arguments{
\item{inputId}{character, the input slot that will be used to access the
value.}

\item{label}{character, display label for the control, or \code{NULL} for no
label.}

\item{value}{logical, initial value.}

\item{color}{Check color. Can be any color given in hex format. Named colors
must be LCARS colors. See \code{\link{lcarsdata}} for options.}

\item{background_color}{background color, as above.}

\item{label_color}{label text color, as above.}

\item{label_right}{logical, set to \code{TRUE} to right align the label.}

\item{width}{a valid CSS unit.}
}
\value{
A checkbox control that can be added to a UI definition
}
\description{
An LCARS styled toggle button that can be used in place of
\code{checkboxInput}.
}
\examples{
## Only run examples in interactive R sessions
if(interactive()){
  ui <- lcarsPage(
    lcarsCheckbox("somevalue", "Some value", FALSE),
    verbatimTextOutput("value")
  )
  server <- function(input, output) {
    output$value <- renderText({ input$somevalue })
  }
  shinyApp(ui, server)
}
}
