% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_import_data.R
\name{mt_import_data}
\alias{mt_import_data}
\title{Import Market Type related Data to R from the Sandbox}
\usage{
mt_import_data(path_sbxm, system_number)
}
\arguments{
\item{path_sbxm}{- String, Path to the sandbox with the log file (master terminal)}

\item{system_number}{- magic number id of the trading system}
}
\value{
function returns the data frame with 5 columns including market type code
}
\description{
Function imports file from the MetaTrader sandbox. Function performs necessary cleansing of the data column types
}
\examples{

library(dplyr)
library(readr)
library(lazytrade)

path_sbxm <- normalizePath(tempdir(),winslash = "/")

file.copy(from = system.file("extdata", "MarketTypeLog9139106.csv", package = "lazytrade"),
          to = file.path(path_sbxm, "MarketTypeLog9139106.csv"), overwrite = TRUE)

DF1 <- mt_import_data(path_sbxm = path_sbxm,
                      system_number = 9139106)



}
\author{
(C) 2020 Vladimir Zhbanko
}
