% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_market_type.R
\name{evaluate_market_type}
\alias{evaluate_market_type}
\title{Function to score data and predict current market type using pre-trained classification model}
\usage{
evaluate_market_type(x, model_path, num_cols)
}
\arguments{
\item{x}{- dataframe with one column containing asset indicator in the time descending order,
typically 64 or more values}

\item{model_path}{- path to the model}

\item{num_cols}{- number of columns (features) in the final vector input to the model}
}
\value{
dataframe with predicted value of the market type
}
\description{
PURPOSE: Function that uses Deep Learning model and Time Series Column of the dataframe
           to find out specific market type of the financial asset
           it will also discard bad result outputting -1 if it is the case
}
\details{
it is mandatory to switch on the virtual h2o machine with h2o.init()
also to shut it down with h2o.shutdown(prompt = F)
}
\examples{

\donttest{

library(h2o)

# start h2o - don't start/stop within for loop
h2o.init()
# Use function to score the data to the model
data(macd_df)
x <- macd_df
num_cols <- 64
models_path <- tempdir()
remain_path <- "/regression.bin/DL_Classification"
model_path <- file.path(models_path, remain_path)

my_market_prediction <- evaluate_market_type(x = df,
                                             model_path = model_path,
                                             num_cols = 64)

h2o.shutdown(prompt = FALSE)

}

}
