% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00lazy-S4-methods.R
\name{lazyraster-raster-S4}
\alias{lazyraster-raster-S4}
\alias{extent}
\alias{crop}
\alias{crop,lazyraster-method}
\alias{raster_lazyraster}
\alias{extent_lazyraster}
\title{Raster methods (S4) for lazyraster.}
\usage{
\S4method{crop}{lazyraster}(x, y, ...)

raster_lazyraster(x, ...)

extent_lazyraster(x, ...)
}
\arguments{
\item{x}{various (raster, extent)}

\item{y}{an object with extent (for crop)}

\item{...}{arguments passed to underlying raster function}
}
\value{
\code{\link[=lazyraster]{lazyraster()}} and \code{\link[=crop]{crop()}} return a lazyraster object, \code{\link[=extent]{extent()}} returns
a regular raster extent
}
\description{
These methods are generics from the raster package, extended to work for lazyrasters.
}
\details{
For \code{\link[=crop]{crop()}} this set an active window of data using the same \code{\link[=crop]{crop()}}
function as the raster package. This is the data window that will be pulled
by conversion to an actual raster by \code{\link[=as_raster]{as_raster()}}.
}
\examples{
sstfile <- system.file("extdata/sst.tif", package = "vapour")
lr <- lazyraster(sstfile)
## crop and stay as lazyraster
crop(lazyraster(sstfile), raster::extent(142, 143, -50, -45))
}
\seealso{
\code{\link[raster:raster]{raster::raster()}}, \code{\link[raster:extent]{raster::extent()}}, \code{\link[raster:crop]{raster::crop()}}
}
