% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lav_vif.R
\name{lav_vif}
\alias{lav_vif}
\alias{print.lav_vif}
\alias{summary.lav_vif}
\title{Variance Inflation Factors for 'lavaan' Structural Predictors}
\usage{
lav_vif(
  fit,
  data = NULL,
  quiet = TRUE
)

\method{print}{lav_vif}(x, digits = 3, cutoff = c(5, 10), ...)

\method{summary}{lav_vif}(object, ...)
}
\arguments{
\item{fit}{A fitted \code{lavaan} object.}

\item{data}{Optional. The data frame used to fit \code{fit}. If \code{NULL},
the function attempts to extract the data from \code{fit} via
\code{lavInspect(fit, "data")} then \code{"data.original"}.}

\item{quiet}{Logical. If \code{TRUE} suppresses lavaan refit messages.}

\item{x}{A 'lav_vif' object.}

\item{digits}{Integer number of digits to print.}

\item{cutoff}{Numeric length-2 thresholds used to flag VIF values.}

\item{...}{Passed to `print.lav_vif()` (e.g., `digits`, `cutoff`).}

\item{object}{A 'lav_vif' object.}
}
\value{
A list with:
\itemize{
  \item \code{vif_table}: data.frame with columns
        \code{outcome}, \code{predictor}, \code{group}, \code{r2_predictor},
        \code{vif}, \code{k_predictors}.
  \item \code{outcome_r2}: data.frame with R^2 per eligible endogenous
        \code{outcome} and \code{group} from the original \code{fit}.
}
}
\description{
Compute VIF for each predictor that appears in structural regressions
with two or more predictors, refitting the necessary sub-models so that
latent predictors are handled at the latent level (i.e., with their original
measurement models). It returns also the R^2 of each eligible endogenous variable 
from the original fit for context.
}
\details{
Each auxiliary refitted model:
\itemize{
  \item includes the original measurement model for any latent predictors;
  \item includes any residual covariances among those indicators that were
        specified in the original model;
  \item regresses the focal predictor on the remaining predictors at the latent 
  level when applicable.
}

VIF_i = 1 / (1 - R^2_i) generalizes VIF to SEM while respecting 
measurement models.
  
The function reuses the estimator, missing-data handling, and several options 
from \code{fit}.
}
\examples{
set.seed(42)
x1 <- rnorm(100); x2 <- 0.85*x1 + rnorm(100, sd = sqrt(1 - 0.85^2)); x3 <- rnorm(100)
y  <- 0.5*x1 + 0.3*x2 + 0.1*x3 + rnorm(100, sd = 0.7)
dataset <- data.frame(y, x1, x2, x3)
fit <- lavaan::sem("y ~ x1 + x2 + x3", data = dataset)
lav_vif(
fit = fit,
data = dataset)

}
