% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{max.lcModels}
\alias{max.lcModels}
\title{Select the lcModel with the highest metric value}
\usage{
\method{max}{lcModels}(x, name, ...)
}
\arguments{
\item{x}{The \code{lcModels} object.}

\item{name}{The name of the internal metric.}

\item{...}{Additional arguments.}
}
\value{
The lcModel with the highest metric value
}
\description{
Select the lcModel with the highest metric value
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")

model1 <- latrend(method, latrendData, nClusters = 1)
model2 <- latrend(method, latrendData, nClusters = 2)
model3 <- latrend(method, latrendData, nClusters = 3)

models <- lcModels(model1, model2, model3)

if (require("clusterCrit")) {
  max(models, "Dunn")
}
}
\seealso{
\link{min.lcModels} \link{externalMetric}
}
