% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelCustom.R
\name{lcModelCustom}
\alias{lcModelCustom}
\title{Specify a model based on a pre-computed result.}
\usage{
lcModelCustom(
  data,
  response,
  trajectoryAssignments = NULL,
  clusterTrajectories = mean,
  trajectories = data,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  clusterNames = NULL,
  converged = TRUE,
  postprob = NULL,
  model = NULL,
  name = "custom",
  predict = NULL,
  predictPostprob = NULL,
  method = new("lcMethod")
)
}
\arguments{
\item{data}{The data on which the cluster result is based, a data.frame.}

\item{response}{The response variable.}

\item{trajectoryAssignments}{A vector indicating cluster membership per strata. Either a \code{numeric} vector with range \code{1:numClus}, or a \code{factor}.}

\item{clusterTrajectories}{The cluster trajectories as a data.frame, or a function computing the center trajectory based on the strata of the respective cluster.}

\item{trajectories}{The fitted trajectories.}

\item{time}{The time variable.}

\item{id}{The id variable.}

\item{clusterNames}{The names of the clusters. Optional.}

\item{converged}{Convergence state of the model. TRUE by default.}

\item{postprob}{Optional posterior probability matrix.}

\item{model}{An optional object representing the internal model.}

\item{name}{The name of the model.}

\item{predict}{Predict function for the response.}

\item{predictPostprob}{Predict function for the posterior probability.}

\item{method}{The method used to create this lcModelCustom instance. Optional.}
}
\description{
Specify a model based on a pre-computed result.
}
