% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodCustom.R
\name{lcMethodCustom}
\alias{lcMethodCustom}
\title{Specify a custom method based on a model function}
\usage{
lcMethodCustom(
  response,
  fun,
  center = meanNA,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  name = "custom"
)
}
\arguments{
\item{response}{The name of the response variable.}

\item{fun}{The cluster \code{function} with signature \verb{(method, data)}.}

\item{center}{Optional \code{function} for computing the longitudinal cluster centers, with signature \code{(x)}.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identification variable.}

\item{name}{The name of the method.}
}
\description{
Specify a custom method based on a model function
}
\examples{
data(latrendData)
# Stratification based on the mean response level
clusfun <- function(data, response, id, time, ...) {
   clusters <- data.table::as.data.table(data)[, mean(Y) > 0, by = Id]$V1
   lcModelCustom(data = data,
     trajectoryAssignments = factor(clusters, levels = c(FALSE, TRUE), labels = c("Low", "High")),
     response = response,
     time = time,
     id = id)
}
method <- lcMethodCustom(response = "Y", fun = clusfun, id = "Id", time = "Time")
model <- latrend(method, data = latrendData)
}
\seealso{
Other lcMethod implementations: 
\code{\link{lcMethod-class}},
\code{\link{lcMethodAKMedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodLongclust}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}},
\code{\link{lcMethodTwoStep}}
}
\concept{lcMethod implementations}
