% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_sheets.R
\name{filesGD}
\alias{filesGD}
\title{Google Drive Files (API v4)}
\usage{
filesGD(title, server = FALSE, json = NULL, api_key = NULL, email = NULL)
}
\arguments{
\item{title}{Character. Title of Google Drive file. Uses regular
expressions so you may fetch with patterns instead of names.}

\item{server}{Boolean. Force interacting auth process?}

\item{json}{Character. JSON filename with service auth}

\item{email, api_key}{Character. If you have multiple pre-authorized
accounts in your machine, you may non-interactively select
which one you wish to use by email and/or api_key.}
}
\value{
Vector with found file names based on \code{title} on Google Drive.
}
\description{
Authenticate and find Google Drive files and IDs by name.
}
\seealso{
Other Scrapper: 
\code{\link{get_mp3}()},
\code{\link{gtrends_related}()},
\code{\link{holidays}()},
\code{\link{ip_data}()},
\code{\link{readGS}()},
\code{\link{splot_etf}()},
\code{\link{stocks_quote}()}

Other Google: 
\code{\link{gtrends_related}()},
\code{\link{queryGA}()},
\code{\link{readGS}()}
}
\concept{Google}
\concept{Scrapper}
