% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour_palettes.R
\name{lares_pal}
\alias{lares_pal}
\title{Personal Colours Palette}
\usage{
lares_pal(return = "list")
}
\arguments{
\item{return}{Character. Get only what you need. Select any of:
"all" or "list" (list),
"colors" or "colours" (vector),
"pal" or "palette" (named vector),
"simple" (named vector),
"custom" or "personal" (data.frame)}
}
\value{
Depending on the \code{return} input, we get a:
\itemize{
  \item \code{vector} with \code{palette} results vector
  \item \code{vector} with \code{palette} results vector's names
  \item \code{list} with \code{palette} results vector, \code{labels}
  results data.frame, and \code{simple} results named vector
}
}
\description{
Fetch customizable palettes for the library's usage. The package has
its own default colour-blind friendly colours but can be customized using
R internal options (i.e. \code{options("lares.palette" = c("#FF8303" = "#000",
"#40A4D8" = "#FFF", ...))}. There are 3 options you can use to customize all
colour palletes: "lares.palette" (vector, will be used in the same order as passed,
and must have a counter colour defined), "lares.colours" (vector, simple colour
names and their HEX codes), and "lares.colours.custom" (data.frame, containing
"values" to use dynamically, "fill" for main colour, and "colour" (not obligatory)
for counter colour).
}
\examples{
# Simple colour-named palette
lares_pal("simple")

# Raw colours and counter-colours
# OR simply: lares_pal("palette")
nice_palette <- lares_pal("colours")
nice_palette_ctr <- as.vector(lares_pal()$palette)
lapply(list(nice_palette, nice_palette_ctr), head)

# Personal colours by name
df <- lares_pal("custom")
df[sample(nrow(df), 5), ]
}
\seealso{
Other Themes: 
\code{\link{gg_fill_customs}()},
\code{\link{plot_palette}()},
\code{\link{theme_lares}()}
}
\concept{Themes}
