% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe_str.R
\name{df_str}
\alias{df_str}
\title{Dataset columns and rows structure}
\usage{
df_str(df, return = "plot", subtitle = NA, quiet = FALSE)
}
\arguments{
\item{df}{Dataframe}

\item{return}{Character. Return "skimr" for skim report, "numbers" for
stats and numbers, "names" for a list with the column names of each of
the class types, "plot" for a nice plot with "numbers" output, "distr"
for an overall summary plot showing categorical, numeric, and missing
values by using \code{plot_df}
distributions}

\item{subtitle}{Character. Add subtitle to plot}

\item{quiet}{Boolean. Keep quiet or show other options available?}
}
\value{
Depending on \code{return} input and based on your \code{df} structure:
\itemize{
  \item \code{list} with the names of the columns classified by class
  \item \code{data.frame} with numbers: total values, row, columns,
  complete rows
  \item \code{plot} with visualizations
}
}
\description{
This function lets the user to check quickly the structure of a
dataset (data.frame). It returns multiple counters for useful metrics,
a plot, and a list of column names for each of the column metrics.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data(dft) # Titanic dataset
df_str(dft, "names")
df_str(dft, "numbers", quiet = TRUE)
df_str(dft, "plot", quiet = TRUE)
}
\seealso{
Other Exploratory: 
\code{\link{corr_cross}()},
\code{\link{corr_var}()},
\code{\link{crosstab}()},
\code{\link{distr}()},
\code{\link{freqs}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{lasso_vars}()},
\code{\link{missingness}()},
\code{\link{plot_cats}()},
\code{\link{plot_df}()},
\code{\link{plot_nums}()},
\code{\link{tree_var}()}
}
\concept{Exploratory}
