% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{stocks_obj}
\alias{stocks_obj}
\title{Portfolio's Calculations and Plots}
\usage{
stocks_obj(
  data = stocks_file(),
  cash_fix = 0,
  tax = 30,
  sectors = FALSE,
  parg = FALSE,
  window = c("1M", "YTD", "1Y", "MAX"),
  cache = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{data}{List. Containing the following dataframes: portfolio,
transactions, cash. They have to follow the original xlsx format}

\item{cash_fix}{Numeric. If, for some reason, you need to fix your
cash amount for all reports, set the amount here}

\item{tax}{Numeric. How much [0-99] of your dividends are gone with taxes?}

\item{sectors}{Boolean. Return sectors segmentation for ETFs?}

\item{parg}{Boolean. Personal argument. Used to personalize stuff, in this
case, taxes changed from A to B in given date (hard-coded)}

\item{window}{Character. Choose any of: "1W", "1M", "6M", "1Y", "YTD", "5Y", "MAX"}

\item{cache}{Boolean. Use daily cache if available?}

\item{quiet}{Boolean. Keep quiet? If not, informative messages will be printed.}
}
\value{
List. Aggregated results and plots.
}
\description{
This function lets the user create his portfolio's calculations and
plots for further study.
}
\seealso{
Other Investment: 
\code{\link{daily_portfolio}()},
\code{\link{daily_stocks}()},
\code{\link{etf_sector}()},
\code{\link{splot_change}()},
\code{\link{splot_divs}()},
\code{\link{splot_etf}()},
\code{\link{splot_growth}()},
\code{\link{splot_roi}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()},
\code{\link{stocks_file}()},
\code{\link{stocks_quote}()},
\code{\link{stocks_report}()}
}
\concept{Investment}
