% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_predict.R
\name{h2o_predict_binary}
\alias{h2o_predict_binary}
\title{H2O Predict using Binary file}
\usage{
h2o_predict_binary(df, model_path, sample = NA)
}
\arguments{
\item{df}{Dataframe. Data to insert into the model.}

\item{model_path}{Character. Relative model path directory or zip file.}

\item{sample}{Integer. How many rows should the function predict?}
}
\value{
vector with predicted results.
}
\description{
This function lets the user predict using the h2o binary file.
Note that it works with the files generated when using the
function export_results(). Recommendation: use the
h2o_predict_MOJO() function when possible - it let's you change
h2o's version without problem.
}
\seealso{
Other Machine Learning: 
\code{\link{ROC}()},
\code{\link{conf_mat}()},
\code{\link{export_results}()},
\code{\link{gain_lift}()},
\code{\link{h2o_automl}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{impute}()},
\code{\link{iter_seeds}()},
\code{\link{lasso_vars}()},
\code{\link{model_metrics}()},
\code{\link{model_preprocess}()},
\code{\link{msplit}()}

Other Tools: 
\code{\link{autoline}()},
\code{\link{bindfiles}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{get_credentials}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{listfiles}()},
\code{\link{mailSend}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{zerovar}()}
}
\concept{Machine Learning}
\concept{Tools}
