% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_plots.R
\name{export_plot}
\alias{export_plot}
\title{Export ggplot2, gridExtra, or any plot object into rendered file}
\usage{
export_plot(
  p,
  name = "plot",
  vars = NA,
  sep = ".vs.",
  width = 8,
  height = 6,
  format = "png",
  res = 300,
  dir = getwd(),
  subdir = NA,
  quiet = FALSE
)

export_plot(
  p,
  name = "plot",
  vars = NA,
  sep = ".vs.",
  width = 8,
  height = 6,
  format = "png",
  res = 300,
  dir = getwd(),
  subdir = NA,
  quiet = FALSE
)
}
\arguments{
\item{p}{Plot object. Plot to render and export.}

\item{name}{Character. File's name or suffix if vars is not \code{NA}. No need
to include file format on file name.}

\item{vars}{Vector. Variable names to identify by filename.}

\item{sep}{Character. Separator for \code{vars}.}

\item{width, height, res}{Numeric. Plot's width, height, and res (for grids).}

\item{format}{Character. One of: \code{png} or \code{jpeg}.}

\item{dir, subdir}{Character. In which directory/subdirectory do you 
wish to save the plot? Working directory as default \code{dir}.}

\item{quiet}{Boolean. Display successful message with filename when saved?}
}
\value{
No return value, called for side effects.

No return value, called for side effects.
}
\description{
Export any \code{ggplot2}, \code{gridExtra}, or any plot object 
created with R into rendered \code{png} or \code{jpg} file.

Export any \code{ggplot2}, \code{gridExtra}, or any plot object 
created with R into rendered \code{png} or \code{jpg} file.
}
\examples{
\donttest{
p <- noPlot()
export_plot(p, name = "noplot", width = 10, height = 8, res = 300, dir = tempdir())
export_plot(p, name = "noplot2", subdir = "newplots", dir = tempdir())
}
\donttest{
p <- noPlot()
export_plot(p, name = "noplot", width = 10, height = 8, res = 300, dir = tempdir())
export_plot(p, name = "noplot2", subdir = "newplots", dir = tempdir())
}
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bindfiles}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_results}()},
\code{\link{get_credentials}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{listfiles}()},
\code{\link{mailSend}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{zerovar}()}

Other Tools: 
\code{\link{autoline}()},
\code{\link{bindfiles}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_results}()},
\code{\link{get_credentials}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{listfiles}()},
\code{\link{mailSend}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{zerovar}()}
}
\concept{Tools}
