% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_relmutinf.R
\name{lsm_l_relmutinf}
\alias{lsm_l_relmutinf}
\title{RELMUTINF (landscape level)}
\usage{
lsm_l_relmutinf(landscape, neighbourhood = 4, ordered = TRUE, base = "log2")
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours:
4 (rook's case) or 8 (queen's case). The default is 4.}

\item{ordered}{The type of pairs considered.
Either ordered (TRUE) or unordered (FALSE).
The default is TRUE.}

\item{base}{The unit in which entropy is measured.
The default is "log2", which compute entropy in "bits".
"log" and "log10" can be also used.}
}
\value{
tibble
}
\description{
Relative mutual information
}
\details{
Due to the spatial autocorrelation, the value of mutual information tends to grow with a diversity of the landscape (marginal entropy). To adjust this tendency, it is possible to calculate relative mutual information by dividing the mutual information by the marginal entropy. Relative mutual information always has a range between 0 and 1 and can be used to compare spatial data with different number and distribution of categories.
When the value of mutual information equals to 0, then relative mutual information is 1.
}
\examples{
lsm_l_relmutinf(landscape)

}
\references{
Nowosad J., TF Stepinski. 2019. Information theory as a consistent framework
for quantification and classification of landscape patterns. https://doi.org/10.1007/s10980-019-00830-x
}
\seealso{
\code{\link{lsm_l_ent}},
\code{\link{lsm_l_condent}},
\code{\link{lsm_l_joinent}},
\code{\link{lsm_l_mutinf}}
}
