% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_centroids.R
\name{get_centroids}
\alias{get_centroids}
\alias{get_centroids.RasterLayer}
\alias{get_centroids.RasterStack}
\alias{get_centroids.RasterBrick}
\alias{get_centroids.stars}
\alias{get_centroids.list}
\title{get_centroids}
\usage{
get_centroids(landscape, directions, cell_center, return_sp, verbose)

\method{get_centroids}{RasterLayer}(
  landscape,
  directions = 8,
  cell_center = FALSE,
  return_sp = FALSE,
  verbose = TRUE
)

\method{get_centroids}{RasterStack}(
  landscape,
  directions = 8,
  cell_center = FALSE,
  return_sp = FALSE,
  verbose = TRUE
)

\method{get_centroids}{RasterBrick}(
  landscape,
  directions = 8,
  cell_center = FALSE,
  return_sp = FALSE,
  verbose = TRUE
)

\method{get_centroids}{stars}(
  landscape,
  directions = 8,
  cell_center = FALSE,
  return_sp = FALSE,
  verbose = TRUE
)

\method{get_centroids}{list}(
  landscape,
  directions = 8,
  cell_center = FALSE,
  return_sp = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{cell_center}{If true, the coordinates of the centroid are forced to be
a cell center within the patch.}

\item{return_sp}{If true, a SpatialPointsDataFrame is returned.}

\item{verbose}{Print warning messages}
}
\description{
Centroid of patches
}
\details{
Get the coordinates of the centroid of each patch. The centroid is by default
defined as the mean location of all cell centers. To force the centroid to be
located within each patch, use the \code{cell_center} argument. In this case, the
centroid is defined as the cell center that is the closest to the mean location.
}
\examples{
# get centroid location
get_centroids(landscape)

}
