% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_cohesion.R
\name{lsm_l_cohesion}
\alias{lsm_l_cohesion}
\alias{lsm_l_cohesion.RasterLayer}
\alias{lsm_l_cohesion.RasterStack}
\alias{lsm_l_cohesion.RasterBrick}
\alias{lsm_l_cohesion.stars}
\alias{lsm_l_cohesion.list}
\title{COHESION (landscape level)}
\usage{
lsm_l_cohesion(landscape, directions)

\method{lsm_l_cohesion}{RasterLayer}(landscape, directions = 8)

\method{lsm_l_cohesion}{RasterStack}(landscape, directions = 8)

\method{lsm_l_cohesion}{RasterBrick}(landscape, directions = 8)

\method{lsm_l_cohesion}{stars}(landscape, directions = 8)

\method{lsm_l_cohesion}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Patch Cohesion Index (Aggregation metric)
}
\details{
\deqn{COHESION = 1 - (\frac{\sum \limits_{i = 1}^{m} \sum \limits_{j = 1}^{n} p_{ij}} {\sum \limits_{i = 1}^{m} \sum \limits_{j = 1}^{n} p_{ij} \sqrt{a_{ij}}}) * (1 - \frac{1} {\sqrt{Z}}) ^ {-1} * 100}
where \eqn{p_{ij}} is the perimeter in meters, \eqn{a_{ij}} is the area in square
meters and \eqn{Z} is the number of cells.

COHESION is an 'Aggregation metric'.

\subsection{Units}{Percent}
\subsection{Ranges}{Unknown}
\subsection{Behaviour}{Unknown}
}
\examples{
lsm_l_cohesion(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

Schumaker, N. H. 1996. Using landscape indices to predict habitat
connectivity. Ecology, 77(4), 1210-1225.
}
\seealso{
\code{\link{lsm_p_perim}},
\code{\link{lsm_p_area}}, \cr
\code{\link{lsm_l_cohesion}}
}
