% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer.dist.R
\name{buffer.dist,SpatialPointsDataFrame,SpatialPixelsDataFrame-method}
\alias{buffer.dist,SpatialPointsDataFrame,SpatialPixelsDataFrame-method}
\alias{buffer.dist}
\title{Derive buffer distances for a list of points}
\usage{
\S4method{buffer.dist}{SpatialPointsDataFrame,SpatialPixelsDataFrame}(
  observations,
  predictionDomain,
  classes,
  width,
  parallel = TRUE,
  ...
)
}
\arguments{
\item{observations}{SpatialPointsDataFrame.}

\item{predictionDomain}{SpatialPixelsDataFrame.}

\item{classes}{vector of selected points as factors.}

\item{width}{maximum width for buffer distance.}

\item{parallel}{optional parallelization setting.}

\item{...}{optional arguments to pass to \code{raster::distance} function.}
}
\value{
object of class \code{SpatialPixelsDataFrame} with distances to points
}
\description{
Derive buffer distances using the \code{raster::distance} function, so that these can be used as predictors for spatial prediction i.e. to account for spatial proximity to low, medium and high values.
}
\examples{
\donttest{
library(raster)
library(rgdal)
demo(meuse, echo=FALSE)
b <- buffer.dist(meuse["zinc"], meuse.grid[1],
        classes=as.factor(1:nrow(meuse)), parallel=FALSE)
}
}
\references{
\itemize{
  \item Hengl, T., Nussbaum, M., Wright, M. N., Heuvelink, G. B., and Gräler, B. (2018) Random Forest as a generic framework for predictive modeling of spatial and spatio-temporal variables. PeerJ 6:e5518. \doi{10.7717/peerj.5518}
}
}
\author{
\href{https://opengeohub.org/people/tom-hengl}{Tom Hengl}
}
