% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landgis.R
\name{download.landgis}
\alias{download.landgis}
\title{Access and download layers from OpenLandMap.org (LandGIS data service)}
\usage{
download.landgis(
  coverageId,
  filename,
  scalefactor = NULL,
  subset = NULL,
  service = paste0(c("https://geoserver.opengeohub.org/landgisgeoserver/ows",
    "?service=WCS&version=2.0.1")),
  silent = TRUE,
  ...
)
}
\arguments{
\item{coverageId}{Coverage ID.}

\item{filename}{Download filename.}

\item{scalefactor}{Scale factor for WCS request.}

\item{subset}{Subset string for WCS request.}

\item{service}{URL of the WCS service.}

\item{silent}{Silent output.}

\item{...}{optional \code{utils::download.file} settings.}
}
\value{
Locally downloaded GeoTIFF.
}
\description{
Access and download layers from OpenLandMap.org (LandGIS data service)
}
\examples{
search.landgis(pattern=c("clay", "10..10cm"))
}
\author{
\href{https://opengeohub.org/people/tom-hengl}{Tom Hengl}
}
