% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_values.R
\name{na_values}
\alias{na_values}
\alias{na_values<-}
\alias{na_range}
\alias{na_range<-}
\alias{set_na_values}
\alias{set_na_range}
\alias{user_na_to_na}
\title{Get / Set SPSS missing values}
\usage{
na_values(x)

na_values(x) <- value

na_range(x)

na_range(x) <- value

set_na_values(.data, ...)

set_na_range(.data, ...)

user_na_to_na(x)
}
\arguments{
\item{x}{A vector.}

\item{value}{A vector of values that should also be considered as missing
(for \code{na_values}) or a numeric vector of length two giving the (inclusive)
extents of the range (for \code{na_values}, use \code{-Inf} and \code{Inf} if you
want the range to be open ended).}

\item{.data}{a data frame}

\item{...}{name-value pairs of missing values (see examples)}
}
\value{
\code{na_values} will return a vector of values that should also be considered as missing.
  \code{na_range} will return a numeric vector of length two giving the (inclusive)
    extents of the range.

\code{set_na_values} and \code{set_na_range} will return an updated
 copy of \code{.data}.
}
\description{
Get / Set SPSS missing values
}
\details{
See \code{\link{labelled_spss}} for a presentation of SPSS's user defined missing values.
Note that \code{is.na} will return \code{TRUE} for user defined misssing values.
You can use \code{\link{user_na_to_na}} to convert user defined missing values to \code{NA}.
}
\note{
\code{set_na_values} and \code{set_na_range} could be used with \code{dplyr}.
}
\examples{
v <- labelled(c(1,2,2,2,3,9,1,3,2,NA), c(yes = 1, no = 3, "don't know" = 9))
v
na_values(v) <- 9
na_values(v)
v
is.na(v)
user_na_to_na(v)
na_values(v) <- NULL
v
na_range(v) <- c(5, Inf)
na_range(v)
v
user_na_to_na(v)
if (require(dplyr)) {
  # setting value labels
  df <- data_frame(s1 = c("M", "M", "F", "F"), s2 = c(1, 1, 2, 9)) \%>\%
    set_value_labels(s2 = c(yes = 1, no = 2)) \%>\%
    set_na_values(s2 = 9)
  na_values(df)

  # removing missing values
  df <- df \%>\% set_na_values(s2 = NULL)
  df$s2
}
}
\seealso{
\code{\link{labelled_spss}}, \code{\link{user_na_to_na}}
}
