% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R
\name{kzpdr.eval}
\alias{kzpdr.eval}
\alias{kzpdr.estimate}
\title{Evaluate Directional Spectrum Data for Wave Frequencies and Directions}
\usage{
kzpdr.eval(rec = ls(1), t.D = 2, t.F = 0.01, ...)

kzpdr.estimate(rec = ls(1), ...)
}
\arguments{
\item{rec}{Data list from the outputs of function \code{kzpdr}. It includes the
data frame for the marked frequency values and corresponding directions.
Defaults is searching for available records in the environment.}

\item{t.D}{Tolerance of direction in degree. Default is 2.}

\item{t.F}{Tolerance of frequency. Default value is 0.01.}

\item{...}{Other arguments. 
\itemize{
 \item      D3    Logic. Deafult is FALSE. If TRUE, output 3D perspective plot; 
        otherwise, 2D plot on frequency-direction surface. 
 \item scale    A two element vector for grid on frequency-direction plant. 
        The first element is for frequency. The second is for degree
        of direction. Default is c(0.005,1).
 \item   ...    ... 
}}
}
\value{
Both \code{kzpdr.eval} and \code{kzpdr.estimate} will return suggested 
	wave frequency and direction values. The data frame of detailed estimation 
for each direction is also included in their returned data list. Beside these,   
\code{kzpdr.estimate} can generate 3D or 2D plots for the supports of each 
suggested wave on direction-frequency parameter plane.
}
\description{
Functions in this group are designed to estimate wave parameters based on 
directional periodogram records. 

   \code{kzpdr} samples the data of wave field, and outputs the average
pattern of periodogram for series in a given direction. A collection of 
these pattern records will be sent to \code{kzpdr.eval} or \code{kzpdr.estimate} 
to estimate the wave frequencies and directions.
}
\details{
The average periodograms for a few pairs of orthogonal spatial
directions can be used to identify frequencies and directions of waves.

    First, function \code{kzpdr} samples the spatial data and generates 
periodograms in orthogonal direction pairs, and the frequencies of spikes 
for each directional periodogram are identified and recorded as the output. 

    Then, \code{kzpdr.spikes} can be used to summarize the outputs of  
\code{kzpdr}. Function \code{kzpdr.eval} or \code{kzpdr.estimate} all
can be used to estimate the wave parameters (frequencies and directions).
\code{kzpdr.estimate} is based on clustering-closure and the tolerances
could be decided automatically. It also provides visualization of the results,
thus this function is more convenient to use.

    Usually, if noise level is low, periodograms of a few direction pairs 
may provide satisfied results. But when the noise is high, you may need to 
intensively sample on different directions over the spatial data array with 
\code{kzpdr}. Generally speaking, when the number of samples increases,
the estimation will become more stable and reliable.
}
\examples{
# load pre-saved data to save running-time
data(kzpdr.demo);  

# estimate the wave parameters
kzpdr.eval(kzpdr.demo, t.D = 3, t.F = 0.01)

# estimation & visualization
kzpdr.estimate(kzpdr.demo)

# For validation of the estimation, see \\code{kzpdr.valid}
# For reconstruction of the signals, see \\code{kzrc}
}
\seealso{
\code{\link{kzpdr}}, \code{\link{kzpdr.valid}}, \code{\link{kzp2}}
  			\code{\link{kzpdr.tol}}, \code{\link{kzpdr.spikes}}
}
\concept{
Kolmogorov-Zurbenko periodogram

directional periodogram

average periodogram
}
\keyword{directional-periodogram}
