% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelcomparison.R
\name{compareCFA}
\alias{compareCFA}
\title{compareCFA}
\usage{
compareCFA(models, fitmeas = c("chisq", "df", "pvalue", "rmsea", "cfi", "tli",
  "srmr", "aic", "bic"), nesting = NULL, scaled = TRUE, chidif = TRUE,
  file = NULL)
}
\arguments{
\item{models}{list of lavaan cfa models to be compared. The models
can be named in the elements of the list.}

\item{fitmeas}{vector of fit measures on which to compare the
models. By default, fitmeas = c("chisq", "df", "pvalue",
"rmsea", "cfi", "tli", "srmr", "aic", "bic", "srmr", "aic",
"bic", "srmr_mplus").  Fit measures that are request but not
found are ignored.}

\item{nesting}{character string indicating the nesting structure
of the models.  Must only contain model names, ">", and "+"
separated by spaces.  The model to the left of a ">" is the
parent model for all models to the right of the same ">", up
until another ">" is reached. When multiple models are nested
in the same parent, they are separated by a "+".}

\item{scaled}{should scaled versions of the fit measures requested
be used if available?  The scaled statistic is determined by
the model estimation method.  The defaul value is TRUE.}

\item{chidif}{should the nested models be compared by using the
anova function? The anova function may pass the model
comparison on to another lavaan function.  The results are
added to the last three columns of the comparison table. The
default value is TRUE.}

\item{file}{Default is NULL, no file created. If output file is desired,
provide a character string for the file name.}
}
\description{
Compare CFA Tables
}
\examples{
\donttest{
## These run longer than 5 seconds
library(lavaan)
library(xtable)
set.seed(123)
genmodel <- "f1 =~ .7*v1 + .7*v2 + .7*v3 + .7*v4 + .7*v5 + .7*v6
f1 ~~ 1*f1"
genmodel2 <- "f1 =~ .7*v1 + .7*v2 + .7*v3 + .7*v4 + .7*v5 + .2*v6
f1 ~~ 1*f1"

dat1 <- simulateData(genmodel, sample.nobs = 300)
dat2 <- simulateData(genmodel2, sample.nobs = 300)
dat1$group <- 0
dat2$group <- 1
dat <- rbind(dat1, dat2)

congModel <- "
              f1 =~ 1*v1 + v2 + v3 + v4 + v5 + v6
    		  f1 ~~ f1
    		  f1 ~0*1
    		 "
weakModel <- "
              f1 =~ 1*v1 + c(L2,L2)*v2 + c(L3,L3)*v3 + c(L4,L4)*v4 + c(L5,L5)*v5 + c(L6,L6)*v6
    		  f1 ~~ f1
    		  f1 ~0*1
    		"
partialweakModel <- "
              f1 =~ 1*v1 + c(L2,L2)*v2 + c(L3,L3)*v3 + c(L4,L4)*v4 + c(L5,L5)*v5 + v6
    		  f1 ~~ f1
    		  f1 ~0*1
    		"
partialweakModel2 <- "
              f1 =~ 1*v1 + c(L2,L2)*v2 + c(L3,L3)*v3 + c(L4,L4)*v4 + v5 + v6
    		  f1 ~~ f1
    		  f1 ~0*1
    		"
partialstrongModel1 <- "
              f1 =~ 1*v1 + c(L2,L2)*v2 + c(L3,L3)*v3 + c(L4,L4)*v4 + c(L5,L5)*v5 + v6
    		  f1 ~~ f1
    		  f1 ~ c(0,NA)*1
    		  v1 ~ c(I1,I1)*1
    		  v2 ~ c(I2,I2)*1
    		  v3 ~ c(I3,I3)*1
    		  v4 ~ c(I4,I4)*1
    		  v5 ~ c(I5,I5)*1
    		  v6 ~ c(I6,I6)*1
    		"
cc1 <- cfa(congModel, data=dat, group="group", meanstructure=TRUE, estimator = "MLR")
cc2 <- cfa(weakModel, data=dat, group="group", meanstructure=TRUE, estimator = "MLR")
cc21 <- cfa(partialweakModel, data=dat, group="group", meanstructure=TRUE, estimator = "MLR")
cc3 <- cfa(partialstrongModel1, data=dat, group="group", meanstructure=TRUE, estimator = "MLR")

models <- list(cc1, cc2, cc21, cc3)
compareCFA(models, nesting = NULL)

models <- list("Configural" = cc1, "Metric" = cc2, "PartialMetric" = cc21, "Scalar" = cc3)
compareCFA(models, nesting = "Configural > Metric + PartialMetric > Scalar")

compareCFA(models, fitmeas = c("chisq", "df", "cfi", "rmsea", "tli"),
nesting = "Configural > Metric + PartialMetric > Scalar")

## Creates output file
## compareCFA(models, fitmeas = c("chisq", "df", "cfi", "rmsea", "tli"),
## nesting = "Configural > Metric + PartialMetric > Scalar", file = "table.tex")
}
}
\author{
Ben Kite
}

