% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FixationFilterFunctions.R
\name{adjust_fixation_timing}
\alias{adjust_fixation_timing}
\title{Adjust the onset and offset of fixations to avoid misclassification of saccade samples as belonging to fixations}
\usage{
adjust_fixation_timing(
  fixation.candidate.starts,
  fixation.candidate.stops,
  x,
  y,
  threshold = 3
)
}
\arguments{
\item{fixation.candidate.starts}{First row in the data included in the fixation}

\item{fixation.candidate.stops}{Last row in the data included in the fixation}

\item{x}{X coordinates}

\item{y}{Y coordinates}

\item{threshold}{Threshold for highest accepted distance from fixation center in MADs from the median. Default 3. If NA, just remove NAs
at the onset and offest of fixation but ignore deviations from fixation center}
}
\value{
data frame with adjusted first and last row of the fixation
}
\description{
Shrink the period classified as a fixation by removing samples close to the onset and offset with excessive differences from the fixation center.
This reduces the risk that samples belonging to saccades are misclassified as belonging to a fixation. The function is used internally by other functions
and should typically not be called outside of them.

adjust_fixation_timing starts by calculating the median (MD) and MAD of the absolute distances from the fixation center of all included samples. The fixation onset
is shifted forwards to the first sample with a distance to the fixation center under t* MAD + MD where t is specified by the input parameter threshold.
Analogously, fixation offset is shifted backwards to the last included sample with distance to the fixation center under t* MAD + MD
}
