% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FixationFilterFunctions.R
\name{cluster2m}
\alias{cluster2m}
\title{Fixation detection by two-means clustering}
\usage{
cluster2m(
  gaze_raw,
  windowlength.ms = 200,
  distance.threshold = 0.7,
  one_degree = 40,
  window.step.size = 6,
  min.fixation.duration = 40,
  weight.threshold = 2,
  xcol = "x.raw",
  ycol = "y.raw",
  merge.ms.threshold = 40,
  downsampling.factors = NA,
  missing.samples.threshold = 0.5
)
}
\arguments{
\item{gaze_raw}{Data frame with unfiltered gaze data. Include the variable timestamp with timing in ms and columns with raw
x and y data as specified by the parameters xcol and ycol or their default values}

\item{windowlength.ms}{Length of the moving analysis windows}

\item{distance.threshold}{Subsequent fixations occurring withing this distance are merged. Set to 0 if you do not want to merge fixations.}

\item{one_degree}{One degree of the visual field in the unit of the raw x and y coordinates, typically pixels}

\item{window.step.size}{Distance between starting points of subsequent analysis windows in samples}

\item{min.fixation.duration}{Minimum duration of accepted fixations. Shorter fixations are discarded}

\item{weight.threshold}{Samples with a transition weight exceeding it are candidates for fixation detection.}

\item{xcol}{Name of the column where raw x values are stored. Default: x.raw}

\item{ycol}{Name of the column where raw y values are stored. Default: y.raw}

\item{merge.ms.threshold}{Only fixations occurring within this time window in milliseconds are merged}

\item{downsampling.factors}{Factors to downsample the data by in calculating fixation weights. If downsampling.factors has the values \code{c(10, 2)}, transition weights will be calculated base on data in
the original sampling rate as well as the two donwsampled data sets.}

\item{missing.samples.threshold}{Remove fixations with a higher proportion of missing samples. Range 0 to 1.}
}
\value{
list including separate data frames for fixations and sample-by-sample data including filtered and unfiltered data.
The "fixations" data frame gives onset, offset, x, y, RMSD and missing samples of each fixation.
}
\description{
Identify fixations in a gaze matrix using identification by two-means clustering. The algorithm is based on Hessels et al 2017. Behavior research methods, 49, 1802-1823.
Data from the left and right eye are not processed separately. Adjust your analysis scripts to include this steps if you want the algorithm to include this step, as in Hessels et al 2017.
Input data must be a data frame with the variables timestamp, x.raw and y.raw as variables. Other variables can
be included but will be ignored. This function does not perform pre-processing in the form of interpolation or smoothing. Use the function process.gaze for this.
Timestamps are assumed to be in milliseconds. Default settings assume that x and y coordinates are in pixels.
The output data is a list with two data frames: fixations includes all detected fixations with coordinates, duration
and a number of other metrics, filt.gaze is a sample-by-sample data frame with time stamps, raw and filtered gaze coordinates for fixations.
If the input downsampling.factors is not empty, transition weights will be calculated based on the data in the original sampling rate and data at all sampling rate specified in this variable.
According to Hessels et al 2017, this step makes the analysis less vulnerable to noise in the data.
}
\examples{
gaze <- cluster2m(sample.data.processed)
}
