% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{kobeDens}
\alias{kobeDens}
\title{kobeDens}
\usage{
kobeDens(x, y, h = c(bandwidth.nrd(x), bandwidth.nrd(y)), n = 11,
  lims = c(range(x), range(y)), na.rm = FALSE)
}
\arguments{
\item{x}{a vector}

\item{y}{a vector}

\item{n}{Number of grid points in each direction. Can be scalar or a length-2 integer vector.}

\item{h}{vector of bandwidths for x and y directions. Defaults to normal reference bandwidth
(see bandwidth.nrd). A scalar value will be taken to apply to both directions.}

\item{lims}{The limits of the rectangle covered by the grid as c(xl, xu, yl, yu).}

\item{na.rm}{logical; if true, any NA and NaN's are removed from x before calculations}
}
\value{
a \code{data.frame} with three variables
\code{x, y} coordinates of the grid points, vectors of length n.
\code{z} An n[1] by n[2] matrix of the estimated density: rows correspond to the value of
x, columns to the value of y.
}
\description{
Calculates the Densities of obervation in a 2D cell using Two-dimensional
 kernel density estimation with an axis-aligned bivariate normal kernel,
 evaluated on a square grid.
}
\examples{
\dontrun{
   y=rnorm(20)
   x  =rnorm(20)
   kobeDens(x,y)}
}

