% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_get_set_kRp.text.R,
%   R/01_class_90_deprecated_classes.R
\docType{methods}
\name{taggedText}
\alias{taggedText}
\alias{taggedText,kRp.text-method}
\alias{taggedText,-methods}
\alias{taggedText<-}
\alias{taggedText<-,kRp.text-method}
\alias{taggedText<-,-methods}
\alias{doc_id}
\alias{doc_id,kRp.text-method}
\alias{doc_id,-methods}
\alias{hasFeature}
\alias{hasFeature,kRp.text-method}
\alias{hasFeature,-methods}
\alias{hasFeature<-}
\alias{hasFeature<-,kRp.text-method}
\alias{hasFeature<-,-methods}
\alias{feature}
\alias{feature,kRp.text-method}
\alias{feature,-methods}
\alias{feature<-}
\alias{feature<-,kRp.text-method}
\alias{feature<-,-methods}
\alias{corpusReadability}
\alias{corpusReadability,kRp.text-method}
\alias{corpusReadability,-methods}
\alias{corpusReadability<-}
\alias{corpusReadability<-,kRp.text-method}
\alias{corpusReadability<-,-methods}
\alias{corpusHyphen}
\alias{corpusHyphen,kRp.text-method}
\alias{corpusHyphen,-methods}
\alias{corpusHyphen<-}
\alias{corpusHyphen<-,kRp.text-method}
\alias{corpusHyphen<-,-methods}
\alias{corpusLexDiv}
\alias{corpusLexDiv,kRp.text-method}
\alias{corpusLexDiv,-methods}
\alias{corpusLexDiv<-}
\alias{corpusLexDiv<-,kRp.text-method}
\alias{corpusLexDiv<-,-methods}
\alias{corpusFreq}
\alias{corpusFreq,kRp.text-method}
\alias{corpusFreq,-methods}
\alias{corpusFreq<-}
\alias{corpusFreq<-,kRp.text-method}
\alias{corpusFreq<-,-methods}
\alias{corpusCorpFreq}
\alias{corpusCorpFreq,kRp.text-method}
\alias{corpusCorpFreq,-methods}
\alias{corpusCorpFreq<-}
\alias{corpusCorpFreq<-,kRp.text-method}
\alias{corpusCorpFreq<-,-methods}
\alias{corpusStopwords}
\alias{corpusStopwords,kRp.text-method}
\alias{corpusStopwords,-methods}
\alias{corpusStopwords<-}
\alias{corpusStopwords<-,kRp.text-method}
\alias{corpusStopwords<-,-methods}
\alias{[,kRp.text,ANY,ANY,ANY-method}
\alias{[,-methods}
\alias{[,kRp.text,ANY,ANY-method}
\alias{[<-,kRp.text,ANY,ANY,ANY-method}
\alias{[<-,-methods}
\alias{[[,kRp.text-method}
\alias{[[,-methods}
\alias{[[,kRp.text,ANY-method}
\alias{[[<-,kRp.text-method}
\alias{[[<-,-methods}
\alias{[[<-,kRp.text,ANY,ANY-method}
\alias{describe,kRp.text-method}
\alias{describe,-methods}
\alias{describe<-,kRp.text-method}
\alias{describe<-,-methods}
\alias{language,kRp.text-method}
\alias{language,-methods}
\alias{language<-,kRp.text-method}
\alias{language<-,-methods}
\alias{diffText}
\alias{diffText,kRp.text-method}
\alias{diffText,-methods}
\alias{diffText<-}
\alias{diffText<-,kRp.text-method}
\alias{diffText<-,-methods}
\alias{originalText}
\alias{originalText,kRp.text-method}
\alias{originalText,-methods}
\alias{is.taggedText}
\alias{is.kRp.text}
\alias{fixObject}
\alias{fixObject,kRp.text-method}
\alias{fixObject,-methods}
\alias{tif_as_tokens_df}
\alias{tif_as_tokens_df,kRp.text-method}
\alias{tif_as_tokens_df,-methods}
\alias{fixObject,kRp.tagged-method}
\alias{fixObject,kRp.txt.freq-method}
\alias{fixObject,kRp.txt.trans-method}
\alias{fixObject,kRp.analysis-method}
\title{Getter/setter methods for koRpus objects}
\usage{
taggedText(obj, add.desc = FALSE, doc_id = FALSE)

\S4method{taggedText}{kRp.text}(obj, add.desc = FALSE, doc_id = FALSE)

taggedText(obj) <- value

\S4method{taggedText}{kRp.text}(obj) <- value

doc_id(obj, ...)

\S4method{doc_id}{kRp.text}(obj, has_id = NULL)

hasFeature(obj, feature = NULL, ...)

\S4method{hasFeature}{kRp.text}(obj, feature = NULL)

hasFeature(obj, feature) <- value

\S4method{hasFeature}{kRp.text}(obj, feature) <- value

feature(obj, feature, ...)

\S4method{feature}{kRp.text}(obj, feature, doc_id = NULL)

feature(obj, feature) <- value

\S4method{feature}{kRp.text}(obj, feature) <- value

corpusReadability(obj, ...)

\S4method{corpusReadability}{kRp.text}(obj, doc_id = NULL)

corpusReadability(obj) <- value

\S4method{corpusReadability}{kRp.text}(obj) <- value

corpusHyphen(obj, ...)

\S4method{corpusHyphen}{kRp.text}(obj, doc_id = NULL)

corpusHyphen(obj) <- value

\S4method{corpusHyphen}{kRp.text}(obj) <- value

corpusLexDiv(obj, ...)

\S4method{corpusLexDiv}{kRp.text}(obj, doc_id = NULL)

corpusLexDiv(obj) <- value

\S4method{corpusLexDiv}{kRp.text}(obj) <- value

corpusFreq(obj, ...)

\S4method{corpusFreq}{kRp.text}(obj)

corpusFreq(obj) <- value

\S4method{corpusFreq}{kRp.text}(obj) <- value

corpusCorpFreq(obj, ...)

\S4method{corpusCorpFreq}{kRp.text}(obj)

corpusCorpFreq(obj) <- value

\S4method{corpusCorpFreq}{kRp.text}(obj) <- value

corpusStopwords(obj, ...)

\S4method{corpusStopwords}{kRp.text}(obj)

corpusStopwords(obj) <- value

\S4method{corpusStopwords}{kRp.text}(obj) <- value

\S4method{[}{kRp.text,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{kRp.text,ANY,ANY,ANY}(x, i, j, ...) <- value

\S4method{[[}{kRp.text}(x, i, doc_id = NULL, ...)

\S4method{[[}{kRp.text}(x, i, doc_id = NULL, ...) <- value

\S4method{describe}{kRp.text}(obj, doc_id = NULL, simplify = TRUE, ...)

\S4method{describe}{kRp.text}(obj, doc_id = NULL, ...) <- value

\S4method{language}{kRp.text}(obj)

\S4method{language}{kRp.text}(obj) <- value

diffText(obj, doc_id = NULL)

\S4method{diffText}{kRp.text}(obj, doc_id = NULL)

diffText(obj) <- value

\S4method{diffText}{kRp.text}(obj) <- value

originalText(obj)

\S4method{originalText}{kRp.text}(obj)

is.taggedText(obj)

is.kRp.text(obj)

fixObject(obj, doc_id = NA)

\S4method{fixObject}{kRp.text}(obj, doc_id = NA)

tif_as_tokens_df(tokens)

\S4method{tif_as_tokens_df}{kRp.text}(tokens)

\S4method{fixObject}{kRp.tagged}(obj, doc_id = NA)

\S4method{fixObject}{kRp.txt.freq}(obj, doc_id = NA)

\S4method{fixObject}{kRp.txt.trans}(obj, doc_id = NA)

\S4method{fixObject}{kRp.analysis}(obj, doc_id = NA)
}
\arguments{
\item{obj}{An arbitrary \code{R} object.}

\item{add.desc}{Logical,
      determines whether the \code{desc} column should be re-written with descriptions
for all POS tags.}

\item{doc_id}{Logical (except for \code{fixObject}, \code{feature}, and \code{[[/[[<-}),
      if \code{TRUE} the \code{doc_id} column will be a factor with the respective value
of the \code{desc} slot, i.\,e.,
      the document ID will be preserved in the data.frame. If used with \code{fixObject}, can be a character string
to set the document ID manually (the default \code{NA} will preserve existing values and not overwrite them). If used with \code{feature} or \code{[[/[[<-},
a character vector to limit the scope to one or more particular document IDs.}

\item{value}{The new value to replace the current with.}

\item{...}{Additional arguments for the generics.}

\item{has_id}{A character vector with \code{doc_id}s to look for in the object. The return value
is then a logical vector of the same length,
      indicating if the respective id was found or not.}

\item{feature}{Character string naming the feature to look for. The return value is logical if a single feature
name is given. If \code{feature=NULL}, a character vector is returned,
      naming all features found in the object.}

\item{x}{An object of class \code{kRp.text} or \code{kRp.hyphen}.}

\item{i}{Defines the row selector (\code{[}) or the name to match (\code{[[}).}

\item{j}{Defines the column selector.}

\item{drop}{Logical,
      whether the result should be coerced to the lowest possible dimension. See \code{\link[base:Extract]{[}} for more details.}

\item{simplify}{Logical, if \code{TRUE} and the result is a list oft length one (i.e.,
      just a single \code{doc_id}),
returns the contents of the single list entry.}

\item{tokens}{An object of class \code{\link[koRpus:kRp.text-class]{kRp.text}}.}
}
\description{
These methods should be used to get or set values of tagged text objects
generated by koRpus functions like \code{\link[koRpus:treetag]{treetag}} or \code{\link[koRpus:tokenize]{tokenize}}.
}
\details{
\itemize{
  \item{\code{taggedText()} }{returns the \code{tokens} slot.}
  \item{\code{doc_id()} }{Returns a character vector of all \code{doc_id} values in the object.}
  \item{\code{describe()} }{returns the \code{desc} slot.}
  \item{\code{language()} }{returns the \code{lang} slot.}
  \item{\code{[}/\code{[[} }{Can be used as a shortcut to index the results of \code{taggedText()}.}
  \item{\code{fixObject} }{returns the same object upgraded to the object structure of this package version (e.g.,
      new columns, changed names, etc.).}
  \item{\code{hasFeature()} }{returns \code{TRUE} or code{FALSE},
      depending on whether the requested feature is present or not.}
  \item{\code{feature()} }{returns the list entry of the \code{feat_list} slot for the requested feature.}
  \item{\code{corpusReadability()} }{returns the list of \code{kRp.readability} objects,
      see \code{\link[koRpus:readability]{readability}}.}
  \item{\code{corpusHyphen()} }{returns the list of \code{kRp.hyphen} objects,
      see \code{\link[koRpus:hyphen]{hyphen}}.}
  \item{\code{corpusLexDiv()} }{returns the list of \code{kRp.TTR} objects,
      see \code{\link[koRpus:lex.div]{lex.div}}.}
  \item{\code{corpusFreq()} }{returns the frequency analysis data from the \code{feat_list} slot,
      see \code{\link[koRpus:freq.analysis]{freq.analysis}}.}
  \item{\code{corpusCorpFreq()} }{returns the \code{kRp.corp.freq} object of the \code{feat_list} slot,
      see for example \code{\link[koRpus:read.corp.custom]{read.corp.custom}}.}
  \item{\code{corpusStopwords()} }{returns the number of stopwords found in each text (if analyzed) from the \code{feat_list} slot.}
  \item{\code{tif_as_tokens_df} }{returns the \code{tokens} slot in a TIF[1] compliant format,
      i.e., \code{doc_id} is not a factor but a character vector.}
  \item{\code{originalText()} }{similar to \code{taggedText()},
      but reverts any transformations back to the original text before returning the \code{tokens} slot.
     Only works if the object has the feature \code{diff}, see examples.}
  \item{\code{diffText()} }{returns the \code{diff} slot, if present.}
}
}
\examples{
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  sample_file <- file.path(
    path.package("koRpus"), "examples", "corpus", "Reality_Winner.txt"
  )
  tokenized.obj <- tokenize(
    txt=sample_file,
    lang="en"
  )

  doc_id(tokenized.obj)

  describe(tokenized.obj)

  language(tokenized.obj)

  taggedText(tokenized.obj)
  tokenized.obj[["token"]]
  tokenized.obj[1:3, "token"]

  tif_as_tokens_df(tokenized.obj)

  # example for originalText()
  tokenized.obj <- jumbleWords(tokenized.obj)
  # now compare the jumbled words to the original
  tokenized.obj[["token"]]
  originalText(tokenized.obj)[["token"]]
} else {}
}
\references{
[1] Text Interchange Formats (\url{https://github.com/ropensci/tif})
}
