\name{FOG}
\alias{FOG}
\title{Readability: Gunning FOG Index}
\usage{
  FOG(txt.file, hyphen = NULL,
    parameters = list(syll = 3, const = 0.4, suffix = c("es", "ed", "ing")),
    ...)
}
\arguments{
  \item{txt.file}{Either an object of class
  \code{\link[koRpus]{kRp.tagged-class}}, a character
  vector which must be be a valid path to a file containing
  the text to be analyzed, or a list of text features. If
  the latter, calculation is done by
  \code{\link[koRpus:readability.num]{readability.num}}.}

  \item{hyphen}{An object of class kRp.hyphen. If
  \code{NULL}, the text will be hyphenated automatically.}

  \item{parameters}{A list with named magic numbers and a
  vector with verb suffixes, defining the relevant
  parameters for the index, or one of \code{"PSK"} or
  \code{"NRI"}.}

  \item{...}{Further valid options for the main function,
  see \code{\link[koRpus:readability]{readability}} for
  details.}
}
\value{
  An object of class
  \code{\link[koRpus]{kRp.readability-class}}.
}
\description{
  This is just a convenient wrapper function for
  \code{\link[koRpus:readability]{readability}}.
}
\details{
  Calculates the Gunning FOG index. In contrast to
  \code{\link[koRpus:readability]{readability}}, which by
  default calculates all possible indices, this function
  will only calculate the index value.

  If \code{parameters="PSK"}, the revised parameters by
  Powers-Sumner-Kearl (1958) are used, and if
  \code{parameters="NRI"}, the simplified parameters from
  the Navy Readability Indexes, respectively.
}
\examples{
\dontrun{
FOG(tagged.text)
}
}
\author{
  m.eik michalke \email{meik.michalke@hhu.de}
}
\references{
  DuBay, W.H. (2004). \emph{The Principles of Readability}.
  Costa Mesa: Impact Information.  WWW:
  \url{http://www.impact-information.com/impactinfo/readability02.pdf};
  22.03.2011.

  Powers, R.D, Sumner, W.A, & Kearl, B.E. (1958). A
  recalculation of four adult readability formulas,
  \emph{Journal of Educational Psychology}, 49(2), 99--105.
}
\keyword{readability}

