% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.r
\name{find_knn}
\alias{find_knn}
\title{kNN search}
\usage{
find_knn(data, k, ..., query = NULL, distance = c("euclidean",
  "cosine", "rankcor"), sym = TRUE)
}
\arguments{
\item{data}{Data matrix}

\item{k}{Number of nearest neighbors}

\item{...}{Unused. All parameters to the right of the \code{...} have to be specified by name (e.g. \code{find_knn(data, k, distance = 'cosine')})}

\item{query}{Query matrix. In \code{knn} and \code{knn_asym}, query and data are identical}

\item{distance}{Distance metric to use. Allowed measures: Euclidean distance (default), cosine distance (\eqn{1-corr(c_1, c_2)}) or rank correlation distance (\eqn{1-corr(rank(c_1), rank(c_2))})}

\item{sym}{Return a symmetric matrix (as long as query is NULL)?}
}
\value{
A \code{\link{list}} with the entries:
\describe{
  \item{\code{index}}{A \eqn{nrow(data) \times k} \link{integer} \link{matrix} containing the indices of the k nearest neighbors for each cell.}
  \item{\code{dist}}{A \eqn{nrow(data) \times k} \link{double} \link{matrix} containing the distances to the k nearest neighbors for each cell.}
  \item{\code{dist_mat}}{
    A \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}} if \code{sym == TRUE},
    else a \code{\link[Matrix:dsCMatrix-class]{dsCMatrix}} (\eqn{nrow(query) \times nrow(data)}).
    Any zero in the matrix (except for the diagonal) indicates that the cells in the corresponding pair are close neighbors.
  }
}
}
\description{
k nearest neighbor search with custom distance function.
}
\examples{
# The default: symmetricised pairwise distances between all rows
pairwise <- find_knn(mtcars, 5L)
image(as.matrix(pairwise$dist_mat))

# Nearest neighbors of a subset within all
mercedeses <- grepl('Merc', rownames(mtcars))
merc_vs_all <- find_knn(mtcars, 5L, query = mtcars[mercedeses, ])
# Replace row index matrix with row name matrix
matrix(
  rownames(mtcars)[merc_vs_all$index],
  nrow(merc_vs_all$index),
  dimnames = list(rownames(merc_vs_all$index), NULL)
)[, -1]  # 1st nearest neighbor is always the same row

}
