% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-conversion.R
\name{knit2pandoc}
\alias{knit2pandoc}
\title{Convert various input files to various output files using \code{knit()} and
Pandoc}
\usage{
knit2pandoc(input, output = NULL, tangle = FALSE, text = NULL,
  quiet = FALSE, envir = parent.frame(), to = "html",
  pandoc_wrapper = NULL, ..., encoding = "UTF-8")
}
\arguments{
\item{input}{Path to the input file.}

\item{output}{Path to the output file for \code{knit()}. If \code{NULL}, this
function will try to guess a default, which will be under the current working
directory.}

\item{tangle}{Boolean; whether to tangle the R code from the input file (like
\code{\link[utils]{Stangle}}).}

\item{text}{A character vector. This is an alternative way to provide the input
file.}

\item{quiet}{Boolean; suppress the progress bar and messages?}

\item{envir}{Environment in which code chunks are to be evaluated,
for example, \code{\link{parent.frame}()}, \code{\link{new.env}()}, or
\code{\link{globalenv}()}).}

\item{to}{Character string giving the Pandoc output format to use.}

\item{pandoc_wrapper}{An R function used to call Pandoc; by default, if
\pkg{rmarkdown} is installed, this uses
\code{rmarkdown::\link[rmarkdown]{pandoc_convert}()}, otherwise it
\code{\link{pandoc}()}.}

\item{...}{Options to be passed to the \code{pandoc_wrapper} function.}

\item{encoding}{Ignored (always assumes UTF-8).}
}
\value{
Returns the output of the \code{pandoc_wrapper} function.
}
\description{
Knits the input file and compiles to an output format using Pandoc.
}
\author{
Trevor L. Davis
}
