context('Capture plots')

in_null_dev = function(expr) {
  pdf(NULL)
  dev.control('enable')
  on.exit(dev.off(), add = TRUE)
  expr
}

test_that('remove blank plots', {
  in_null_dev({
    # remove the a blank plot
    res = evaluate('layout(t(1:2))')
  })
  expect_identical(sapply(rm_blank_plot(res), class), 'source')
})

test_that('plots generated by par() or layout() are removed', {

  in_null_dev({
    res = evaluate('par(mfrow = c(1, 2))\npie(islands)\nbarplot(islands)')
    res1 = rm_blank_plot(res)
  })
  expect_identical(sapply(merge_low_plot(res1), class),
                   rep(c('source', 'recordedplot'), c(3, 1)))

  in_null_dev({
    res = evaluate('layout(t(1:2))\npie(islands)\nbarplot(islands)')
    res1 = rm_blank_plot(res)
  })
  expect_identical(sapply(merge_low_plot(res1), class),
                   rep(c('source', 'recordedplot'), c(3, 1)))

  in_null_dev({
    res = evaluate('pie(islands)\nbarplot(islands)\npar(mfrow = c(1, 2))')
    res1 = rm_blank_plot(res)
  })
  expect_identical(sapply(merge_low_plot(res1), class),
                   rep(c('source', 'recordedplot'), length = 5))

})

test_that('merge low-level changes', {
  in_null_dev({
    res = evaluate('plot(1)\npoints(1.1, 1.1)')
  })
  expect_identical(sapply(merge_low_plot(res), class),
                   rep(c('source', 'recordedplot'), c(2, 1)))
})

test_that('captures grid graphics', {
  in_null_dev({
    res = evaluate('library(grid)
    grid.newpage()
    grid.rect(gp=gpar(fill="grey"))
    grid.rect(gp=gpar(fill="red"))')
  })
  expect_identical(sapply(res, class), c('source', 'recordedplot')[c(1, 1, 1, 2, 1, 2)])
})
