% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeRs_statistics.R
\name{kmeRs_statistics}
\alias{kmeRs_statistics}
\title{Calculate And Add Basic Statistics To The K-mers Similarity Matrix}
\usage{
kmeRs_statistics(kmeRs_similarity_matrix,
  summary_statistics_only = FALSE)
}
\arguments{
\item{kmeRs_similarity_matrix}{matrix calculated by \code{kmeRs_similarity_matrix} function}

\item{summary_statistics_only}{when parameter is set to TRUE only the summarized table with
statistics is returned}
}
\value{
data.frame with results
}
\description{
The \code{kmeRs_statistics} function calculates basic statistics and returns the similarity matrix
with calculated results or summarized table with statistics only when summary_statistics_only
is set to TRUE
}
\examples{
# Simple BLOSUM62 similarity matrix for DNA nucleotides
example  <- kmeRs_similarity_matrix(kmers_given = c("A", "T", "C", "G"), submat = "BLOSUM62")

# Result as a full matrix
kmeRs_statistics(example)

# Result a summary statistics table
kmeRs_statistics(example, summary_statistics_only = TRUE)

}
