\name{triperplines}
\alias{triperplines}
\encoding{latin1}
\title{Barycentric plots}
\description{Function to add a point and the corresponding perpendicular lines to all three 
    sides to an existing (barycentric) plot.}
\usage{
triperplines(x, y = NULL, z = NULL, lcol = "red", pch = 17, ...)
}
\arguments{
  \item{x}{fraction of first component
    OR 3-element vector (for all three components, omitting \code{y} and \code{z}).}
  \item{y}{(optional) fraction of second component.}
  \item{z}{(optional) fraction of third component.}
  \item{lcol}{line color}
  \item{pch}{plotting character. \code{pch = 0} for no point}
  \item{\dots}{Further graphical parameters (see \code{\link{points}}, \code{\link{lines}} and \code{\link{par}}).}
}
\details{
Adds a (single!) point and lines to an existing plot (generated by \code{\link{triplot}}).
The lines originate from the point and run (perpendicular) towards all three sides. 
The lengths (and proportions) of these lines are identical to those of \code{x}, \code{y} and \code{z}.
}
\value{
a 2-column-matrix containing plot coordinates.
}
\author{Christian Rver, \email{roever@statistik.tu-dortmund.de}}
\seealso{\code{\link{triplot}}, \code{\link{tripoints}}, \code{\link{trilines}}, \code{\link{tritrafo}}}
\examples{
triplot()  # empty plot 
triperplines(1/2, 1/3, 1/6)
}
\keyword{aplot}
\concept{Visualizing Classification Performance Measures}
\concept{Barycentric plots}
