% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KinPairSimulation.R
\name{kernelshape,KinPairSimulation-method}
\alias{kernelshape,KinPairSimulation-method}
\alias{simtype,KinPairSimulation-method}
\alias{kerneltype,KinPairSimulation-method}
\alias{posigma,KinPairSimulation-method}
\alias{initsigma,KinPairSimulation-method}
\alias{breedsigma,KinPairSimulation-method}
\alias{gravsigma,KinPairSimulation-method}
\alias{ovisigma,KinPairSimulation-method}
\alias{simdims,KinPairSimulation-method}
\alias{filtertype,KinPairSimulation-method}
\alias{upper,KinPairSimulation-method}
\alias{lower,KinPairSimulation-method}
\alias{spacing,KinPairSimulation-method}
\alias{samplenum,KinPairSimulation-method}
\alias{sampledims,KinPairSimulation-method}
\alias{upper<-,KinPairSimulation-method}
\alias{lower<-,KinPairSimulation-method}
\alias{spacing<-,KinPairSimulation-method}
\alias{samplenum<-,KinPairSimulation-method}
\alias{sampledims<-,KinPairSimulation-method}
\alias{show,KinPairSimulation-method}
\alias{initialize,KinPairSimulation-method}
\title{)}
\usage{
\S4method{kernelshape}{KinPairSimulation}(x)

\S4method{simtype}{KinPairSimulation}(x)

\S4method{kerneltype}{KinPairSimulation}(x)

\S4method{posigma}{KinPairSimulation}(x)

\S4method{initsigma}{KinPairSimulation}(x)

\S4method{breedsigma}{KinPairSimulation}(x)

\S4method{gravsigma}{KinPairSimulation}(x)

\S4method{ovisigma}{KinPairSimulation}(x)

\S4method{simdims}{KinPairSimulation}(x)

\S4method{filtertype}{KinPairSimulation}(x)

\S4method{upper}{KinPairSimulation}(x)

\S4method{lower}{KinPairSimulation}(x)

\S4method{spacing}{KinPairSimulation}(x)

\S4method{samplenum}{KinPairSimulation}(x)

\S4method{sampledims}{KinPairSimulation}(x)

\S4method{upper}{KinPairSimulation}(x) <- value

\S4method{lower}{KinPairSimulation}(x) <- value

\S4method{spacing}{KinPairSimulation}(x) <- value

\S4method{samplenum}{KinPairSimulation}(x) <- value

\S4method{sampledims}{KinPairSimulation}(x) <- value

\S4method{show}{KinPairSimulation}(object)

\S4method{initialize}{KinPairSimulation}(
  .Object,
  data = NULL,
  kinship = NULL,
  lifestage = NULL,
  simtype = NULL,
  kerneltype = NULL,
  kernelshape = NULL,
  posigma = NULL,
  initsigma = NULL,
  breedsigma = NULL,
  gravsigma = NULL,
  ovisigma = NULL,
  simdims = NULL,
  call = NULL,
  filtertype = NULL,
  upper = NULL,
  lower = NULL,
  spacing = NULL,
  samplenum = NULL,
  sampledims = NULL
)
}
\arguments{
\item{x}{object of class KinPairSimulation}

\item{value}{value for parameter to be adjusted to}

\item{object}{object of class KinPairSimulation}

\item{.Object}{object to be constructed into KinPairSimulation class}

\item{data}{tbl_df. tibble  of simulation values}

\item{kinship}{character - one of PO, FS, HS, AV, HAV, GG, 1C, H1C, GAV, HGAV, 1C1, H1C1, GGG, 2C, and H2C.}

\item{lifestage}{character - one of 'unknown', 'immature' or 'ovipositional'}

\item{simtype}{character - simulation type}

\item{kerneltype}{character. - 'Gaussian', 'Laplace' or 'vgamma' (variance-gamma)}

\item{kernelshape}{numeric. - value of kernel shape of simulation (if using kernel with shape parameter e.g. vgamma)}

\item{posigma}{numeric - overall value of dispersal sigma (for simple kernel)}

\item{initsigma}{numeric.    - value of pre-breeding dispersal sigma (for composite kernel)}

\item{breedsigma}{numeric.    - value of breeding dispersal sigma (for composite kernel)}

\item{gravsigma}{numeric.    - value of post-breeding dispersal sigma (for composite kernel)}

\item{ovisigma}{numeric.    - value of oviposition dispersal sigma (for composite kernel)}

\item{simdims}{numeric. - dimensions of sampling area (assumes one side of square)}

\item{call}{call. Call to create object}

\item{filtertype}{character. whether the initial sim has been further filtered}

\item{upper}{numeric.       - FILTER: upper threshold used}

\item{lower}{numeric.       - FILTER: lower threshold used}

\item{spacing}{numeric.       - FILTER: spacing used}

\item{samplenum}{numeric.       - FILTER: sample number used}

\item{sampledims}{numeric.       - FILTER: sample dimensions used}

\item{KinPairSimulation}{an object of class KinPairSimulation}
}
\value{
\code{character} the shape parameter used in kernel simulation (if \code{kerneltype} is vgamma)

\code{character} the kind of simulation stored in the object (simple or composite)

\code{character} the type of statistical kernel used to run the simulation (Gaussian, Laplace, vgamma)

\code{numeric} posigma value of simple simulation

\code{numeric} initsigma value of composite simulation

\code{numeric} breedsigma value of composite simulation

\code{numeric} gravsigma value of composite simulation

\code{numeric} ovisigma value of composite simulation

\code{numeric vector} simulation dimensions of \code{KinPairSimulation} object

\code{character} filter status of \code{KinPairSimulation} object

\code{numeric} upper value of sampled \code{KinPairSimulation} object

\code{numeric} lower value of sampled \code{KinPairSimulation} object

\code{numeric} trap spacing value of sampled \code{KinPairSimulation} object

\code{numeric} number of kin dyads in \code{KinPairSimulation} object

\code{numeric vector} sampling dimensions of \code{KinPairSimulation} object

returns a modified object of class \code{KinPairSimulation}

returns a modified object of class \code{KinPairSimulation}

returns a modified object of class \code{KinPairSimulation}

returns a modified object of class \code{KinPairSimulation}

returns a modified object of class \code{KinPairSimulation}

No return value, called for side effects

Returns an object of class \code{KinPairSimulation}
}
\description{
)
}
\section{Methods (by generic)}{
\itemize{
\item \code{kernelshape}: access kernelshape

\item \code{simtype}: access simulation type

\item \code{kerneltype}: access kerneltype

\item \code{posigma}: access sigma

\item \code{initsigma}: access initsigma

\item \code{breedsigma}: access breedsigma

\item \code{gravsigma}: access gravsigma

\item \code{ovisigma}: access ovisigma

\item \code{simdims}: access simdims

\item \code{filtertype}: access filtertype

\item \code{upper}: access upper filter distance

\item \code{lower}: access lower filter distance

\item \code{spacing}: access spacing

\item \code{samplenum}: access sampled samplenum

\item \code{sampledims}: access sampled dimensions

\item \code{upper<-}: assign and filter by upper distance (uses sample_kindist())

\item \code{lower<-}: assign and filter by lower distance (uses sample_kindist())

\item \code{spacing<-}: assign kin spacing (uses sample_kindist())

\item \code{samplenum<-}: assign and downsample to samplenum (uses sample_kindist())

\item \code{sampledims<-}: assign and filter by sample dimensions (uses sample_kindist())

\item \code{show}: print method

\item \code{initialize}: initialisation method
}}

