% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_independent_rs.R
\name{compare_independent_rs}
\alias{compare_independent_rs}
\title{Compare independent correlations}
\usage{
compare_independent_rs(
  r1 = NULL,
  n1 = NULL,
  r2 = NULL,
  n2 = NULL,
  one_tailed = FALSE,
  round_p = 3,
  round_z_diff = 2,
  round_r = 2,
  print_summary = TRUE,
  output_type = NULL
)
}
\arguments{
\item{r1}{correlation in the first sample}

\item{n1}{size of the first sample}

\item{r2}{correlation in the second sample}

\item{n2}{size of the first sample}

\item{one_tailed}{logical. Should the p value based on a one-tailed
t-test? (default = FALSE)}

\item{round_p}{(only for displaying purposes) number of decimal
places to which to round the p-value (default = 3)}

\item{round_z_diff}{(only for displaying purposes) number of
decimal places to which to round the z-score (default = 2)}

\item{round_r}{(only for displaying purposes) number of
decimal places to which to round correlation coefficients (default = 2)}

\item{print_summary}{logical. Should the summary be printed?
(default = TRUE)}

\item{output_type}{type of the output. If \code{output_type = "z"},
the function's output will be the z-score of the difference between
the two correlations. If \code{output_type = "p"}, the function's
output will be the p-value associated with the z-score of the
difference between the two correlations. By default,
\code{output_type = NULL}, and the function will not return any
value other than the printed summary.}
}
\value{
the output will be the results of a test comparing two
independent correlations.
}
\description{
Compares whether two correlations from two independent samples are
significantly different each other.
See Field et al. (2012, ISBN: 978-1-4462-0045-2).
}
\examples{
compare_independent_rs(r1 = .1, n1 = 100, r2 = .2, n2 = 200)
compare_independent_rs(
r1 = .1, n1 = 100, r2 = .2, n2 = 200, one_tailed = TRUE)
compare_independent_rs(r1 = .506, n1 = 52, r2 = .381, n2 = 51)
}
