% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kexpmv.R
\name{mat2crs}
\alias{mat2crs}
\title{Convert matrix to CRS format using SparseM function}
\usage{
mat2crs(mat)
}
\arguments{
\item{mat}{A square matrix.}
}
\description{
The \code{EXPOKIT}'s \code{expokit_dmexpv} and \code{expokit_dgexpv} functions both deal with sparse matrices.
These matrices have a lot of zeros, and can therefore be stored more efficiently by converting the
matrix into CRS (Compressed Row Storage) format.\cr
}
\details{
In \code{EXPOKIT} and its wrapper functions, a CRS-formatted matrix is input as
3 vectors:\cr

ia = row pointer. This vector stores the location in the `a' vector that is the first non-zero element 
in a row. \cr
ja = column indices for non-zero elements.\cr
a = non-zero elements of the matrix.\cr
}
\examples{
# Make a square matrix
mat=matrix(c(-0.071207, 0, 0, 0.065573, -0.041206, 0, 0.005634, 0.014206, 0), nrow=3, byrow=TRUE)

# Covert to CRS format
mat2crs(mat)
print(mat)

}
\author{
Meabh G. McCurdy \email{mmccurdy01@qub.ac.uk}
}
