% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{random_seed_generator}
\alias{random_seed_generator}
\title{Generates variable seeds upon each call to a function generating random numbers.}
\usage{
random_seed_generator(seed = NULL, name = NULL, ...)
}
\arguments{
\item{seed}{Initial seed for the random number generator}

\item{name}{String, name for the object}

\item{...}{For forward/backward compatability.}
}
\value{
A \code{SeedGenerator} instance, which can be passed as the \verb{seed = }
argument to other random tensor generators.
}
\description{
In Keras, all random number generators (such as
\code{\link[=random_normal]{random_normal()}}) are stateless, meaning that if you pass an
integer seed to them (such as \code{seed=42}), they will return the same
values for repeated calls. To get different values for each
call, a \code{SeedGenerator} providing the state of the random generator
has to be used.

Note that all the random number generators have a default seed of \code{NULL},
which implies that an internal global \code{SeedGenerator} is used.
If you need to decouple the RNG from the global state you can provide
a local \code{StateGenerator} with either a deterministic or random initial
state.

Remark concerning the JAX backen: Note that the use of a local
\code{StateGenerator} as seed argument is required for JIT compilation of
RNG with the JAX backend, because the use of global state is not
supported.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{seed_gen <- random_seed_generator(seed = 42)
values <- random_normal(shape = c(2, 3), seed = seed_gen)
new_values <- random_normal(shape = c(2, 3), seed = seed_gen)
}\if{html}{\out{</div>}}

Usage in a layer:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{layer_dropout2 <- new_layer_class(
  "dropout2",
  initialize = function(...) \{
    super$initialize(...)
    self$seed_generator <- random_seed_generator(seed = 1337)
  \},
  call = function(x, training = FALSE) \{
    if (training) \{
      return(random_dropout(x, rate = 0.5, seed = self$seed_generator))
    \}
    return(x)
  \}
)

out <- layer_dropout(rate = 0.8)
out(op_ones(10), training = TRUE)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor([0. 5. 5. 0. 0. 0. 0. 0. 0. 0.], shape=(10), dtype=float32)

}\if{html}{\out{</div>}}
}

\seealso{
Other random: \cr
\code{\link{random_beta}()} \cr
\code{\link{random_binomial}()} \cr
\code{\link{random_categorical}()} \cr
\code{\link{random_dropout}()} \cr
\code{\link{random_gamma}()} \cr
\code{\link{random_integer}()} \cr
\code{\link{random_normal}()} \cr
\code{\link{random_shuffle}()} \cr
\code{\link{random_truncated_normal}()} \cr
\code{\link{random_uniform}()} \cr
}
\concept{random}
