% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{sequential_model_input_layer}
\alias{sequential_model_input_layer}
\title{sequential_model_input_layer}
\usage{
sequential_model_input_layer(
  input_shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  input_tensor = NULL,
  sparse = NULL,
  name = NULL,
  ragged = NULL,
  type_spec = NULL,
  ...,
  input_layer_name = NULL
)
}
\arguments{
\item{input_shape}{an integer vector of dimensions (not including the batch
axis), or a \code{tf$TensorShape} instance (also not including the batch axis).}

\item{batch_size}{Optional input batch size (integer or NULL).}

\item{dtype}{Optional datatype of the input. When not provided, the Keras
default float type will be used.}

\item{input_tensor}{Optional tensor to use as layer input. If set, the layer
will use the \code{tf$TypeSpec} of this tensor rather than creating a new
placeholder tensor.}

\item{sparse}{Boolean, whether the placeholder created is meant to be sparse.
Default to \code{FALSE}.}

\item{ragged}{Boolean, whether the placeholder created is meant to be ragged.
In this case, values of 'NULL' in the 'shape' argument represent ragged
dimensions. For more information about \code{RaggedTensors}, see this
\href{https://www.tensorflow.org/guide/ragged_tensor}{guide}. Default to
\code{FALSE}.}

\item{type_spec}{A \code{tf$TypeSpec} object to create Input from. This
\code{tf$TypeSpec} represents the entire batch. When provided, all other args
except name must be \code{NULL}.}

\item{...}{additional arguments passed on to \code{keras$layers$InputLayer}.}

\item{input_layer_name, name}{Optional name of the input layer (string).}
}
\description{
sequential_model_input_layer
}
