% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{image_dataset_from_directory}
\alias{image_dataset_from_directory}
\title{Create a dataset from a directory}
\usage{
image_dataset_from_directory(
  directory,
  labels = "inferred",
  label_mode = "int",
  class_names = NULL,
  color_mode = "rgb",
  batch_size = 32,
  image_size = c(256, 256),
  shuffle = TRUE,
  seed = NULL,
  validation_split = NULL,
  subset = NULL,
  interpolation = "bilinear",
  follow_links = FALSE
)
}
\arguments{
\item{directory}{Directory where the data is located. If labels is "inferred",
it should contain subdirectories, each containing images for a class.
Otherwise, the directory structure is ignored.}

\item{labels}{Either "inferred" (labels are generated from the directory
structure), or a list/tuple of integer labels of the same size as the number
of image files found in the directory. Labels should be sorted according to
the alphanumeric order of the image file paths (obtained via
os.walk(directory) in Python).}

\item{label_mode}{\itemize{
\item 'int': means that the labels are encoded as integers
(e.g. for sparse_categorical_crossentropy loss). - 'categorical' means that
the labels are encoded as a categorical vector (e.g. for
categorical_crossentropy loss). - 'binary' means that the labels (there can
be only 2) are encoded as float32 scalars with values 0 or 1 (e.g. for
binary_crossentropy). - None (no labels).
}}

\item{class_names}{Only valid if "labels" is "inferred". This is the explict
list of class names (must match names of subdirectories). Used to control
the order of the classes (otherwise alphanumerical order is used).}

\item{color_mode}{One of "grayscale", "rgb", "rgba". Default: "rgb". Whether
the images will be converted to have 1, 3, or 4 channels.}

\item{batch_size}{Size of the batches of data. Default: 32.}

\item{image_size}{Size to resize images to after they are read from disk.
Defaults to (256, 256). Since the pipeline processes batches of images that
must all have the same size, this must be provided.}

\item{shuffle}{Whether to shuffle the data. Default: TRUE. If set to FALSE,
sorts the data in alphanumeric order.}

\item{seed}{Optional random seed for shuffling and transformations.}

\item{validation_split}{Optional float between 0 and 1, fraction of data to
reserve for validation.}

\item{subset}{One of "training" or "validation". Only used if validation_split
is set.}

\item{interpolation}{String, the interpolation method used when resizing
images. Defaults to bilinear. Supports bilinear, nearest, bicubic, area,
lanczos3, lanczos5, gaussian, mitchellcubic.}

\item{follow_links}{Whether to visits subdirectories pointed to by symlinks.
Defaults to FALSE.}
}
\description{
Generates a \code{tf.data.Dataset} from image files in a directory.
If your directory structure is:
}
