% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_keras}
\alias{install_keras}
\title{Install Keras and the TensorFlow backend}
\usage{
install_keras(method = c("auto", "virtualenv", "conda"),
  conda = "auto", version = "default", tensorflow = "default",
  extra_packages = c("tensorflow-hub"))
}
\arguments{
\item{method}{Installation method ("virtualenv" or "conda")}

\item{conda}{Path to conda executable (or "auto" to find conda using the
PATH and other conventional install locations).}

\item{version}{Version of Keras to install. Specify "default" to install
the latest release. Otherwise specify an alternate version (e.g. "2.2.2").}

\item{tensorflow}{TensorFlow version to install. Specify "default" to install
the CPU version of the latest release. Specify "gpu" to install the GPU
version of the latest release.

You can also provide a full major.minor.patch specification (e.g. "1.1.0"),
appending "-gpu" if you want the GPU version (e.g. "1.1.0-gpu").

Alternatively, you can provide the full URL to an installer binary (e.g.
for a nightly binary).}

\item{extra_packages}{Additional PyPI packages to install along with
Keras and TensorFlow.}
}
\description{
Keras and TensorFlow will be installed into an "r-tensorflow" virtual or conda
environment. Note that "virtualenv" is not available on Windows (as this isn't
supported by TensorFlow).
}
\section{GPU Installation}{


Keras and TensorFlow can be configured to run on either CPUs or GPUs. The CPU
version is much easier to install and configure so is the best starting place
especially when you are first learning how to use Keras. Here's the guidance
on CPU vs. GPU versions from the TensorFlow website:
\itemize{
\item \emph{TensorFlow with CPU support only}. If your system does not have a NVIDIA® GPU,
you must install this version. Note that this version of TensorFlow is typically
much easier to install, so even if you have an NVIDIA GPU, we recommend installing
this version first.
\item \emph{TensorFlow with GPU support}. TensorFlow programs typically run significantly
faster on a GPU than on a CPU. Therefore, if your system has a NVIDIA® GPU meeting
all prerequisites and you need to run performance-critical applications, you should
ultimately install this version.
}

To install the GPU version:
\enumerate{
\item Ensure that you have met all installation prerequisites including installation
of the CUDA and cuDNN libraries as described in \href{https://tensorflow.rstudio.com/installation_gpu.html#prerequisites}{TensorFlow GPU Prerequistes}.
\item Pass \code{tensorflow = "gpu"} to \code{install_keras()}. For example:\preformatted{  install_keras(tensorflow = "gpu")
}
}
}

\section{Windows Installation}{


The only supported installation method on Windows is "conda". This means that you
should install Anaconda 3.x for Windows prior to installing Keras.
}

\section{Custom Installation}{


Installing Keras and TensorFlow using \code{install_keras()} isn't required
to use the Keras R package. You can do a custom installation of Keras (and
desired backend) as described on the \href{https://keras.io/#installation}{Keras website}
and the Keras R package will find and use that version.

See the documentation on \href{https://tensorflow.rstudio.com/installation.html#custom-installation}{custom installations}
for additional information on how version of Keras and TensorFlow are located
by the Keras package.
}

\section{Additional Packages}{


If you wish to add additional PyPI packages to your Keras / TensorFlow environment you
can either specify the packages in the \code{extra_packages} argument of \code{install_keras()},
or alternatively install them into an existing environment using the
\code{\link[reticulate:py_install]{reticulate::py_install()}} function.
}

\examples{
\dontrun{

# default installation
library(keras)
install_keras()

# install using a conda environment (default is virtualenv)
install_keras(method = "conda")

# install with GPU version of TensorFlow
# (NOTE: only do this if you have an NVIDIA GPU + CUDA!)
install_keras(tensorflow = "gpu")

# install a specific version of TensorFlow
install_keras(tensorflow = "1.2.1")
install_keras(tensorflow = "1.2.1-gpu")

}

}
