% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-activations.R
\name{layer_activation}
\alias{layer_activation}
\title{Apply an activation function to an output.}
\usage{
layer_activation(object, activation, input_shape = NULL,
  batch_input_shape = NULL, batch_size = NULL, dtype = NULL,
  name = NULL, trainable = NULL, weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{activation}{Name of activation function to use. If you don't specify
anything, no activation is applied (ie. "linear" activation: a(x) = x).}

\item{input_shape}{Input shape (list of integers, does not include the
samples axis) which is required when using this layer as the first layer in
a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Apply an activation function to an output.
}
\seealso{
Other core layers: \code{\link{layer_activity_regularization}},
  \code{\link{layer_dense}}, \code{\link{layer_dropout}},
  \code{\link{layer_flatten}}, \code{\link{layer_input}},
  \code{\link{layer_lambda}}, \code{\link{layer_masking}},
  \code{\link{layer_permute}},
  \code{\link{layer_repeat_vector}},
  \code{\link{layer_reshape}}

Other activation layers: \code{\link{layer_activation_elu}},
  \code{\link{layer_activation_leaky_relu}},
  \code{\link{layer_activation_parametric_relu}},
  \code{\link{layer_activation_relu}},
  \code{\link{layer_activation_softmax}},
  \code{\link{layer_activation_thresholded_relu}}
}
