% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_local_conv1d}
\alias{k_local_conv1d}
\title{Apply 1D conv with un-shared weights.}
\usage{
k_local_conv1d(inputs, kernel, kernel_size, strides, data_format = NULL)
}
\arguments{
\item{inputs}{3D tensor with shape: (batch_size, steps, input_dim)}

\item{kernel}{the unshared weight for convolution, with shape
(output_length, feature_dim, filters)}

\item{kernel_size}{a list of a single integer, specifying the length of the
1D convolution window}

\item{strides}{a list of a single integer, specifying the stride length of
the convolution}

\item{data_format}{the data format, channels_first or channels_last}
}
\value{
the tensor after 1d conv with un-shared weights, with shape
(batch_size, output_length, filters)
}
\description{
Apply 1D conv with un-shared weights.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

