% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-methods.R
\name{get_input_at}
\alias{get_input_at}
\alias{get_output_at}
\alias{get_input_shape_at}
\alias{get_output_shape_at}
\alias{get_input_mask_at}
\alias{get_output_mask_at}
\title{Retrieve tensors for layers with multiple nodes}
\usage{
get_input_at(object, node_index)

get_output_at(object, node_index)

get_input_shape_at(object, node_index)

get_output_shape_at(object, node_index)

get_input_mask_at(object, node_index)

get_output_mask_at(object, node_index)
}
\arguments{
\item{object}{Layer or model object}

\item{node_index}{Integer, index of the node from which to retrieve the
attribute. E.g. \code{node_index = 1} will correspond to the first time the
layer was called.}
}
\value{
A tensor (or list of tensors if the layer has multiple inputs/outputs).
}
\description{
Whenever you are calling a layer on some input, you are creating a new tensor
(the output of the layer), and you are adding a "node" to the layer, linking
the input tensor to the output tensor. When you are calling the same layer
multiple times, that layer owns multiple nodes indexed as 1, 2, 3. These
functions enable you to retrieve various tensor properties of layers with
multiple nodes.
}
\seealso{
Other layer methods: \code{\link{count_params}},
  \code{\link{get_config}}, \code{\link{get_weights}},
  \code{\link{reset_states}}
}
