% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callback_backup_and_restore}
\alias{callback_backup_and_restore}
\title{Callback to back up and restore the training state}
\usage{
callback_backup_and_restore(backup_dir, ...)
}
\arguments{
\item{backup_dir}{String, path to store the checkpoint.
e.g. \code{backup_dir = normalizePath('./backup')}
This is the directory in which the system stores temporary files to
recover the model from jobs terminated unexpectedly. The directory
cannot be reused elsewhere to store other files, e.g. by
\code{BackupAndRestore} callback of another training, or by another callback
(\code{ModelCheckpoint}) of the same training.}

\item{...}{For backwards and forwards compatibility}
}
\description{
Callback to back up and restore the training state
}
\details{
\code{BackupAndRestore} callback is intended to recover training from an
interruption that has happened in the middle of a \code{fit(model)} execution, by
backing up the training states in a temporary checkpoint file (with the help
of a \code{tf.train.CheckpointManager}), at the end of each epoch. Each backup
overwrites the previously written checkpoint file, so at any given time there
is at most one such checkpoint file for backup/restoring purpose.

If training restarts before completion, the training state (which includes the
\code{Model} weights and epoch number) is restored to the most recently saved state
at the beginning of a new \code{fit()} run. At the completion of a \code{fit()}
run, the temporary checkpoint file is deleted.

Note that the user is responsible to bring jobs back after the interruption.
This callback is important for the backup and restore mechanism for fault
tolerance purpose, and the model to be restored from an previous checkpoint is
expected to be the same as the one used to back up. If user changes arguments
passed to compile or fit, the checkpoint saved for fault tolerance can become
invalid.

Note:
\enumerate{
\item This callback is not compatible with eager execution disabled.
\item A checkpoint is saved at the end of each epoch. After restoring,
\code{fit()} redoes any partial work during the unfinished epoch in which the
training got restarted (so the work done before the interruption doesn't
affect the final model state).
\item This works for both single worker and multi-worker modes. When \code{fit()}
is used with \code{tf.distribute}, it supports \code{tf.distribute.MirroredStrategy},
\code{tf.distribute.MultiWorkerMirroredStrategy}, \code{tf.distribute.TPUStrategy}, and
\code{tf.distribute.experimental.ParameterServerStrategy}.
}
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/callbacks/BackupAndRestore}
}
}
