% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers.R
\name{optimizer_adagrad}
\alias{optimizer_adagrad}
\title{Optimizer that implements the Adagrad algorithm}
\usage{
optimizer_adagrad(
  learning_rate = 0.001,
  initial_accumulator_value = 0.1,
  epsilon = 1e-07,
  weight_decay = NULL,
  clipnorm = NULL,
  clipvalue = NULL,
  global_clipnorm = NULL,
  use_ema = FALSE,
  ema_momentum = 0.99,
  ema_overwrite_frequency = NULL,
  jit_compile = TRUE,
  name = "Adagrad",
  ...
)
}
\arguments{
\item{learning_rate}{Initial value for the learning rate:
either a floating point value,
or a \code{tf.keras.optimizers.schedules.LearningRateSchedule} instance.
Defaults to 0.001.
Note that \code{Adagrad} tends to benefit from higher initial learning rate
values compared to other optimizers.
To match the exact form in the original paper, use 1.0.}

\item{initial_accumulator_value}{Floating point value.
Starting value for the accumulators (per-parameter momentum values).
Must be non-negative.}

\item{epsilon}{Small floating point value used to maintain numerical stability.}

\item{weight_decay}{Float, defaults to NULL. If set, weight decay is applied.}

\item{clipnorm}{Float. If set, the gradient of each weight is individually
clipped so that its norm is no higher than this value.}

\item{clipvalue}{Float. If set, the gradient of each weight is clipped to be no
higher than this value.}

\item{global_clipnorm}{Float. If set, the gradient of all weights is clipped so
that their global norm is no higher than this value.}

\item{use_ema}{Boolean, defaults to FALSE. If TRUE, exponential moving average
(EMA) is applied. EMA consists of computing an exponential moving
average of the weights of the model (as the weight values change after
each training batch), and periodically overwriting the weights with
their moving average.}

\item{ema_momentum}{Float, defaults to 0.99. Only used if \code{use_ema=TRUE}. This is  # noqa: E501
the momentum to use when computing the EMA of the model's weights:
\code{new_average = ema_momentum * old_average + (1 - ema_momentum) * current_variable_value}.}

\item{ema_overwrite_frequency}{Int or NULL, defaults to NULL. Only used if
\code{use_ema=TRUE}. Every \code{ema_overwrite_frequency} steps of iterations, we
overwrite the model variable by its moving average. If NULL, the optimizer  # noqa: E501
does not overwrite model variables in the middle of training, and you
need to explicitly overwrite the variables at the end of training
by calling \code{optimizer.finalize_variable_values()} (which updates the model  # noqa: E501
variables in-place). When using the built-in \code{fit()} training loop, this
happens automatically after the last epoch, and you don't need to do
anything.}

\item{jit_compile}{Boolean, defaults to TRUE. If TRUE, the optimizer will use XLA  # noqa: E501
compilation. If no GPU device is found, this flag will be ignored.}

\item{name}{String. The name to use
for momentum accumulator weights created by
the optimizer.}

\item{...}{Used for backward and forward compatibility}
}
\value{
Optimizer for use with \code{\link{compile.keras.engine.training.Model}}.
}
\description{
Optimizer that implements the Adagrad algorithm
}
\details{
Adagrad is an optimizer with parameter-specific learning rates,
which are adapted relative to how frequently a parameter gets
updated during training. The more updates a parameter receives,
the smaller the updates.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/optimizers/experimental/Adagrad}
}

Other optimizers: 
\code{\link{optimizer_adadelta}()},
\code{\link{optimizer_adamax}()},
\code{\link{optimizer_adam}()},
\code{\link{optimizer_ftrl}()},
\code{\link{optimizer_nadam}()},
\code{\link{optimizer_rmsprop}()},
\code{\link{optimizer_sgd}()}
}
\concept{optimizers}
