% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learning_rate_schedules.R
\name{learning_rate_schedule_piecewise_constant_decay}
\alias{learning_rate_schedule_piecewise_constant_decay}
\title{A LearningRateSchedule that uses a piecewise constant decay schedule}
\usage{
learning_rate_schedule_piecewise_constant_decay(
  boundaries,
  values,
  ...,
  name = NULL
)
}
\arguments{
\item{boundaries}{A list of \code{Tensor}s or R numerics with strictly increasing
entries, and with all elements having the same type as the optimizer step.}

\item{values}{A list of \code{Tensor}s or R numerics that specifies the
values for the intervals defined by \code{boundaries}. It should have one more
element than \code{boundaries}, and all elements should have the same type.}

\item{...}{For backwards and forwards compatibility}

\item{name}{A string. Optional name of the operation. Defaults to
'PiecewiseConstant'.}
}
\description{
A LearningRateSchedule that uses a piecewise constant decay schedule
}
\details{
The function returns a 1-arg callable to compute the piecewise constant
when passed the current optimizer step. This can be useful for changing the
learning rate value across different invocations of optimizer functions.

Example: use a learning rate that's 1.0 for the first 100001 steps, 0.5
for the next 10000 steps, and 0.1 for any additional steps.

\if{html}{\out{<div class="sourceCode R">}}\preformatted{step <- tf$Variable(0, trainable=FALSE)
boundaries <- as.integer(c(100000, 110000))
values <- c(1.0, 0.5, 0.1)
learning_rate_fn <- learning_rate_schedule_piecewise_constant_decay(
    boundaries, values)

# Later, whenever we perform an optimization step, we pass in the step.
learning_rate <- learning_rate_fn(step)
}\if{html}{\out{</div>}}

You can pass this schedule directly into a keras Optimizer
as the \code{learning_rate}.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/optimizers/schedules/PiecewiseConstantDecay}
}
}
