% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-attention.R
\name{layer_attention}
\alias{layer_attention}
\title{Dot-product attention layer, a.k.a. Luong-style attention}
\usage{
layer_attention(
  inputs,
  use_scale = FALSE,
  score_mode = "dot",
  ...,
  dropout = NULL
)
}
\arguments{
\item{inputs}{List of the following tensors:
\itemize{
\item query: Query Tensor of shape \verb{[batch_size, Tq, dim]}.
\item value: Value Tensor of shape \verb{[batch_size, Tv, dim]}.
\item key: Optional key Tensor of shape \verb{[batch_size, Tv, dim]}. If not
given, will use value for both key and value, which is the most common
case.
}}

\item{use_scale}{If \code{TRUE}, will create a scalar variable to scale the attention
scores.}

\item{score_mode}{Function to use to compute attention scores, one of
\verb{\{"dot", "concat"\}}. \code{"dot"} refers to the dot product between the query
and key vectors. \code{"concat"} refers to the hyperbolic tangent of the
concatenation of the query and key vectors.}

\item{...}{standard layer arguments (e.g., batch_size, dtype, name, trainable, weights)}

\item{dropout}{Float between 0 and 1. Fraction of the units to drop for the
attention scores. Defaults to 0.0.}
}
\description{
Dot-product attention layer, a.k.a. Luong-style attention
}
\details{
inputs are \code{query} tensor of shape \verb{[batch_size, Tq, dim]}, \code{value} tensor
of shape \verb{[batch_size, Tv, dim]} and \code{key} tensor of shape
\verb{[batch_size, Tv, dim]}. The calculation follows the steps:
\enumerate{
\item Calculate scores with shape \verb{[batch_size, Tq, Tv]} as a \code{query}-\code{key} dot
product: \code{scores = tf$matmul(query, key, transpose_b=TRUE)}.
\item Use scores to calculate a distribution with shape
\verb{[batch_size, Tq, Tv]}: \code{distribution = tf$nn$softmax(scores)}.
\item Use \code{distribution} to create a linear combination of \code{value} with
shape \verb{[batch_size, Tq, dim]}:
return \code{tf$matmul(distribution, value)}.
}
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/Attention}
}

Other core layers: 
\code{\link{layer_activation}()},
\code{\link{layer_activity_regularization}()},
\code{\link{layer_dense_features}()},
\code{\link{layer_dense}()},
\code{\link{layer_dropout}()},
\code{\link{layer_flatten}()},
\code{\link{layer_input}()},
\code{\link{layer_lambda}()},
\code{\link{layer_masking}()},
\code{\link{layer_permute}()},
\code{\link{layer_repeat_vector}()},
\code{\link{layer_reshape}()}
}
\concept{attention layers}
\concept{core layers}
