% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_binary_accuracy}
\alias{metric_binary_accuracy}
\alias{metric_binary_crossentropy}
\alias{metric_categorical_accuracy}
\alias{metric_categorical_crossentropy}
\alias{metric_cosine_proximity}
\alias{metric_hinge}
\alias{metric_kullback_leibler_divergence}
\alias{metric_mean_absolute_error}
\alias{metric_mean_absolute_percentage_error}
\alias{metric_mean_squared_error}
\alias{metric_mean_squared_logarithmic_error}
\alias{metric_poisson}
\alias{metric_sparse_categorical_crossentropy}
\alias{metric_squared_hinge}
\alias{metric_top_k_categorical_accuracy}
\alias{metric_sparse_top_k_categorical_accuracy}
\title{Model performance metrics}
\usage{
metric_binary_accuracy(y_true, y_pred)

metric_binary_crossentropy(y_true, y_pred)

metric_categorical_accuracy(y_true, y_pred)

metric_categorical_crossentropy(y_true, y_pred)

metric_cosine_proximity(y_true, y_pred)

metric_hinge(y_true, y_pred)

metric_kullback_leibler_divergence(y_true, y_pred)

metric_mean_absolute_error(y_true, y_pred)

metric_mean_absolute_percentage_error(y_true, y_pred)

metric_mean_squared_error(y_true, y_pred)

metric_mean_squared_logarithmic_error(y_true, y_pred)

metric_poisson(y_true, y_pred)

metric_sparse_categorical_crossentropy(y_true, y_pred)

metric_squared_hinge(y_true, y_pred)

metric_top_k_categorical_accuracy(y_true, y_pred, k = 5)

metric_sparse_top_k_categorical_accuracy(y_true, y_pred, k = 5)
}
\arguments{
\item{y_true}{True labels (tensor)}

\item{y_pred}{Predictions (tensor of the same shape as y_true).}

\item{k}{An integer, number of top elements to consider.}
}
\description{
Model performance metrics
}
\note{
Metric functions are to be supplied in the \code{metrics} parameter of the
\code{\link[=compile]{compile()}} function.
}
\section{Custom Metrics}{

You can provide an arbitrary R function as a custom metric. Note that
the \code{y_true} and \code{y_pred} parameters are tensors, so computations on
them should use backend tensor functions. See below for an example.

Note that a name ('mean_pred') is provided for the custom metric
function. This name is used within training progress output.

If you want to save and load a model with custom metrics, you should
also specify the metric in the call the \code{\link[=load_model_hdf5]{load_model_hdf5()}}. For example:
\code{load_model_hdf5("my_model.h5", c('mean_pred' = metric_mean_pred))}.

Alternatively, you can wrap all of your code in a call to
\code{\link[=with_custom_object_scope]{with_custom_object_scope()}} which will allow you to refer to the
metric by name just like you do with built in keras metrics.

Documentation on the available backend tensor functions can be
found at \url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

\section{Metrics with Parameters}{


To use metrics with parameters (e.g. \code{metric_top_k_categorical_accurary()})
you should create a custom metric that wraps the call with the parameter.
See below for an example.
}

\examples{
\dontrun{

# create metric using backend tensor functions
metric_mean_pred <- function(y_true, y_pred) {
  k_mean(y_pred) 
}

model \%>\% compile(
  optimizer = optimizer_rmsprop(),
  loss = loss_binary_crossentropy,
  metrics = c('accuracy', 
              'mean_pred' = metric_mean_pred)
)

# create custom metric to wrap metric with parameter
metric_top_3_categorical_accuracy <- function(y_true, y_pred) {
  metric_top_k_categorical_accuracy(y_true, y_pred, k = 3) 
}

model \%>\% compile(
  loss = 'categorical_crossentropy',
  optimizer = optimizer_rmsprop(),
  metrics = c(top_3_categorical_accuracy = metric_top_3_categorical_accuracy)
)
}
}
